import { Extension, FunctionExtension, ThemeExtension, UIExtension } from './extensions.js';
import { AppErrors } from './loader.js';
import { schema } from '@shopify/cli-kit/node/schema';
import { DotEnvFile } from '@shopify/cli-kit/node/dot-env';
import { PackageManager } from '@shopify/cli-kit/node/node-package-manager';
export declare const AppConfigurationSchema: schema.ZodObject<{
    scopes: schema.ZodDefault<schema.ZodString>;
    extensionDirectories: schema.ZodOptional<schema.ZodArray<schema.ZodString, "many">>;
    webDirectories: schema.ZodOptional<schema.ZodArray<schema.ZodString, "many">>;
}, "strip", schema.ZodTypeAny, {
    extensionDirectories?: string[] | undefined;
    webDirectories?: string[] | undefined;
    scopes: string;
}, {
    scopes?: string | undefined;
    extensionDirectories?: string[] | undefined;
    webDirectories?: string[] | undefined;
}>;
export declare enum WebType {
    Frontend = "frontend",
    Backend = "backend"
}
export declare const WebConfigurationSchema: schema.ZodObject<{
    type: schema.ZodEnum<[WebType.Frontend, WebType.Backend]>;
    authCallbackPath: schema.ZodOptional<schema.ZodUnion<[schema.ZodEffects<schema.ZodString, string, string>, schema.ZodArray<schema.ZodEffects<schema.ZodString, string, string>, "many">]>>;
    webhooksPath: schema.ZodOptional<schema.ZodEffects<schema.ZodString, string, string>>;
    commands: schema.ZodObject<{
        build: schema.ZodOptional<schema.ZodString>;
        dev: schema.ZodString;
    }, "strip", schema.ZodTypeAny, {
        build?: string | undefined;
        dev: string;
    }, {
        build?: string | undefined;
        dev: string;
    }>;
}, "strip", schema.ZodTypeAny, {
    authCallbackPath?: string | string[] | undefined;
    webhooksPath?: string | undefined;
    type: WebType;
    commands: {
        build?: string | undefined;
        dev: string;
    };
}, {
    authCallbackPath?: string | string[] | undefined;
    webhooksPath?: string | undefined;
    type: WebType;
    commands: {
        build?: string | undefined;
        dev: string;
    };
}>;
export type AppConfiguration = schema.infer<typeof AppConfigurationSchema>;
export type WebConfiguration = schema.infer<typeof WebConfigurationSchema>;
export type WebConfigurationCommands = keyof WebConfiguration['commands'];
export interface Web {
    directory: string;
    configuration: WebConfiguration;
    framework?: string;
}
export interface AppInterface {
    name: string;
    idEnvironmentVariableName: string;
    directory: string;
    packageManager: PackageManager;
    configuration: AppConfiguration;
    configurationPath: string;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    extensions: {
        ui: UIExtension[];
        theme: ThemeExtension[];
        function: FunctionExtension[];
    };
    errors?: AppErrors;
    hasExtensions: () => boolean;
    hasUIExtensions: () => boolean;
    updateDependencies: () => Promise<void>;
    extensionsForType: (spec: {
        identifier: string;
        externalIdentifier: string;
    }) => Extension[];
}
export declare class App implements AppInterface {
    name: string;
    idEnvironmentVariableName: string;
    directory: string;
    packageManager: PackageManager;
    configuration: AppConfiguration;
    configurationPath: string;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    errors?: AppErrors;
    extensions: {
        ui: UIExtension[];
        theme: ThemeExtension[];
        function: FunctionExtension[];
    };
    constructor(name: string, idEnvironmentVariableName: string, directory: string, packageManager: PackageManager, configuration: AppConfiguration, configurationPath: string, nodeDependencies: {
        [key: string]: string;
    }, webs: Web[], ui: UIExtension[], theme: ThemeExtension[], functions: FunctionExtension[], usesWorkspaces: boolean, dotenv?: DotEnvFile, errors?: AppErrors);
    updateDependencies(): Promise<void>;
    hasExtensions(): boolean;
    hasUIExtensions(): boolean;
    extensionsForType(specification: {
        identifier: string;
        externalIdentifier: string;
    }): Extension[];
}
type RendererVersionResult = {
    name: string;
    version: string;
} | undefined | 'not_found';
/**
 * Given a UI extension and the app it belongs to, it returns the version of the renderer package.
 * Looks for `/node_modules/@shopify/{renderer-package-name}/package.json` to find the real version used.
 * @param uiExtensionType - UI extension whose renderer version will be obtained.
 * @param app - App object containing the extension.
 * @returns The version if the dependency exists.
 */
export declare function getUIExtensionRendererVersion(extension: UIExtension, app: AppInterface): Promise<RendererVersionResult>;
export declare function getDependencyVersion(dependency: string, directory: string): Promise<RendererVersionResult>;
export {};
