export { createUIExtensionSpecification } from '../../models/extensions/ui.js';
export { createFunctionSpecification } from '../../models/extensions/functions.js';
export { fetchProductVariant } from '../../utilities/extensions/fetch-product-variant.js';
export { loadLocalesConfig } from '../../utilities/extensions/locales-configuration.js';
export * from '../../models/extensions/schemas.js';
/**
 * A function for plugins to register new UI extension types.
 *
 * @param specifications - The UI extension specifications to register.
 * @returns A function that returns the list of specifications.
 * @example
 */
export const registerUIExtensionSpecifications = (specifications) => {
    return async () => specifications;
};
/**
 * A function for plugins to register new function types.
 *
 * @param specifications - The function specifications to register.
 * @returns A function that returns the list of specifications.
 * @example
 */
export const registerFunctionSpecifications = (specifications) => {
    return async () => specifications;
};
//# sourceMappingURL=extension.js.map