import { AppInterface } from '../../models/app/app.js';
import { FunctionSpec } from '../../models/extensions/functions.js';
import { GenericSpecification } from '../../models/app/extensions.js';
import { UIExtensionSpec } from '../../models/extensions/ui.js';
import { DependencyVersion } from '@shopify/cli-kit/node/node-package-manager';
interface ExtensionInitOptions<TSpec extends GenericSpecification = GenericSpecification> {
    name: string;
    app: AppInterface;
    cloneUrl?: string;
    extensionFlavor?: ExtensionFlavor;
    specification: TSpec;
    extensionType: string;
}
interface ExtensionDirectory {
    extensionDirectory: string;
}
export type ExtensionFlavor = 'vanilla-js' | 'react' | 'typescript' | 'typescript-react' | 'rust' | 'wasm';
type UIExtensionInitOptions = ExtensionInitOptions<UIExtensionSpec> & ExtensionDirectory;
export type TemplateFlavor = 'javascript' | 'rust' | 'wasm';
declare function extensionInit(options: ExtensionInitOptions): Promise<string>;
export declare function getExtensionRuntimeDependencies({ specification, extensionFlavor, }: Pick<UIExtensionInitOptions, 'specification' | 'extensionFlavor'>): DependencyVersion[];
export declare function getFunctionRuntimeDependencies(specification: FunctionSpec, templateFlavor: string): DependencyVersion[];
export default extensionInit;
