'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the account belonging to the customer.
 *
 * The value is a `Customer` if the customer has an account and is logged in,
 * `undefined` otherwise.
 */
function useCustomer() {
  const buyerIdentity = api.useExtensionApi().buyerIdentity;
  if (!buyerIdentity) {
    throw new errors.ScopeNotGrantedError('Using buyer identity requires having personal customer data permissions granted to your app.');
  }
  return subscription.useSubscription(buyerIdentity.customer);
}
function useEmail() {
  const buyerIdentity = api.useExtensionApi().buyerIdentity;
  if (!buyerIdentity) {
    throw new errors.ScopeNotGrantedError('Using buyer identity requires having personal customer data permissions granted to your app.');
  }
  return subscription.useSubscription(buyerIdentity.email);
}
function usePhone() {
  const buyerIdentity = api.useExtensionApi().buyerIdentity;
  if (!buyerIdentity) {
    throw new errors.ScopeNotGrantedError('Using buyer identity requires having personal customer data permissions granted to your app.');
  }
  return subscription.useSubscription(buyerIdentity.phone);
}

exports.useCustomer = useCustomer;
exports.useEmail = useEmail;
exports.usePhone = usePhone;
