'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the `buyerJourney` details on buyer progression in checkout.
 */
function useBuyerJourney() {
  return api.useExtensionApi().buyerJourney;
}

/**
 * Returns true if the buyer completed submitting their order.
 *
 * For example, when viewing the order status page after submitting payment, the buyer will have completed their order.
 */
function useBuyerJourneyCompleted() {
  const buyerJourney = api.useExtensionApi().buyerJourney;
  const buyerJourneyCompleted = subscription.useSubscription(buyerJourney.completed);
  return buyerJourneyCompleted;
}

/**
 * Returns a function to intercept and block navigation in checkout.
 */
function useBuyerJourneyIntercept(interceptor) {
  const buyerJourney = api.useExtensionApi().buyerJourney;
  const interceptorRef = react.useRef(interceptor);
  interceptorRef.current = interceptor;
  react.useEffect(() => {
    const teardownPromise = buyerJourney.intercept(interceptorProps => interceptorRef.current(interceptorProps));
    return () => {
      teardownPromise.then(teardown => teardown()).catch(() => {});
    };
  }, [buyerJourney]);
}

exports.useBuyerJourney = useBuyerJourney;
exports.useBuyerJourneyCompleted = useBuyerJourneyCompleted;
exports.useBuyerJourneyIntercept = useBuyerJourneyIntercept;
