'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current line items for the checkout, and automatically re-renders
 * your component if line items are added, removed, or updated.
 */
function useCartLines() {
  const {
    lines
  } = api.useExtensionApi();
  return subscription.useSubscription(lines);
}

/**
 * Returns a function to mutate the `lines` property of checkout.
 */
function useApplyCartLinesChange() {
  return api.useExtensionApi().applyCartLinesChange;
}

exports.useApplyCartLinesChange = useApplyCartLinesChange;
exports.useCartLines = useCartLines;
