'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current discount codes applied to the cart, and automatically re-renders
 * your component if discount codes are added or removed.
 */
function useDiscountCodes() {
  const {
    discountCodes
  } = api.useExtensionApi();
  return subscription.useSubscription(discountCodes);
}

/**
 * Returns the current discount allocations applied to the cart, and automatically re-renders
 * your component if discount allocations changed.
 */
function useDiscountAllocations() {
  const {
    discountAllocations
  } = api.useExtensionApi();
  return subscription.useSubscription(discountAllocations);
}

/**
 * Returns a function to add or remove discount codes.
 */
function useApplyDiscountCodeChange() {
  return api.useExtensionApi().applyDiscountCodeChange;
}

exports.useApplyDiscountCodeChange = useApplyDiscountCodeChange;
exports.useDiscountAllocations = useDiscountAllocations;
exports.useDiscountCodes = useDiscountCodes;
