'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var metafields = require('./metafields.js');

/**
 * Returns a single filtered `Metafield` or `undefined`.
 * @arg {MetafieldFilter} - filter the list of returned metafields to a single metafield
 */
function useMetafield(filters) {
  const {
    namespace,
    key
  } = filters;
  if (!namespace || !key) {
    throw new errors.CheckoutUIExtensionError('You must pass in both a namespace and key');
  }
  const metafields$1 = metafields.useMetafields({
    namespace,
    key
  });
  return metafields$1.length ? metafields$1[0] : undefined;
}

exports.useMetafield = useMetafield;
