'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `note` applied to the checkout.
 */
function useNote() {
  return subscription.useSubscription(api.useExtensionApi().note);
}

/**
 * Returns a function to mutate the `note` property of the checkout.
 */
function useApplyNoteChange() {
  return api.useExtensionApi().applyNoteChange;
}

exports.useApplyNoteChange = useApplyNoteChange;
exports.useNote = useNote;
