'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var api = require('./api.js');

/**
 * Returns the `I18nTranslate` interface used to translate strings.
 */
function useTranslate() {
  const {
    i18n
  } = api.useExtensionApi();
  const translate = react.useCallback((...args) => {
    const translation = i18n.translate(...args);
    if (!Array.isArray(translation)) {
      return translation;
    }
    return translation.map((part, index) => {
      if ( /*#__PURE__*/react.isValidElement(part)) {
        return /*#__PURE__*/react.cloneElement(part, {
          key: index
        });
      }
      return part;
    });
  }, [i18n]);
  return translate;
}

exports.useTranslate = useTranslate;
