import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the buyer's language, as supported by the extension.
 */
function useExtensionLanguage() {
  const {
    localization
  } = useExtensionApi();
  return useSubscription(localization.extensionLanguage);
}

export { useExtensionLanguage };
