import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

class ExtensionHasNoTargetError extends Error {
  constructor(extensionPoint) {
    super(`Cannot call 'useTarget()' on extensionPoint '${extensionPoint}'. Property 'target' is not found on api.`);
    this.name = 'ExtensionHasNoTargetError';
  }
}

/**
 * Returns the cart line the extension is attached to. This is only applicable to the `Checkout::CartLineDetails::RenderAfter` extension point.
 */
function useTarget() {
  const api = useExtensionApi();
  if (!api.target) {
    throw new ExtensionHasNoTargetError(api.extensionPoint);
  }
  return useSubscription(api.target);
}

export { useTarget };
