import type { MaybeResponsiveConditionalStyle } from '../../style';
import type { Spacing } from '../shared';
export interface BlockSpacerProps {
    /**
     * Adjust size of the spacer
     *
     * @defaultValue 'base'
     **/
    spacing?: MaybeResponsiveConditionalStyle<Exclude<Spacing, 'none'>>;
}
/**
 * BlockSpacer is used to create empty block space, typically when variable spacing
 * is needed between multiple elements.
 *
 * Note that you should favor BlockStack when spacing between all elements is the same.
 */
export declare const BlockSpacer: "BlockSpacer" & {
    readonly type?: "BlockSpacer" | undefined;
    readonly props?: BlockSpacerProps | undefined;
    readonly children?: false | undefined;
};
//# sourceMappingURL=BlockSpacer.d.ts.map