## Best practices

- Use banners thoughtfully and sparingly, and only for the most important information. Too many banners distract customers from completing checkout.
- Banners are typically displayed at the top of a page or a section, if they relate to specific content. Place banners below the relevant page or section header.
- Include a [`Button`](https://github.com/Shopify/ui-extensions/tree/main/packages/checkout-ui-extensions/src/components/Button) component with next steps when possible.
- Make banners dismissible, unless they contain critical information or an important step that customers need to take.
- Use the `info` banner to update customers about a change or to give them advice.
- Use the `warning` banner to display information that needs attention or that customers need to take action on. Warning banners can be stressful for customers, so be cautious about using them.
- Use the `critical` banner to communicate problems that customers need to resolve immediately to complete checkout.
