# Text

Text is used to visually style and provide semantic value for a small piece of text
content.

## Props
optional = ?

| Name | Type | Description |
| --- | --- | --- |
| size? | <code>"extraSmall" &#124; "small" &#124; "base" &#124; "large" &#124; "extraLarge" &#124; "medium"</code> | Size of the text |
| emphasis? | <code>"italic" &#124; "bold"</code> | Use to emphasize a word or a group of words.<br /><br /><code>"italic"</code>: Set the text in italic. Combine with an `accessibilityRole` of `offset` or `stress` to add more meaning to the text.<br /><br /><code>"bold"</code>: Set the text in bold. Combine with an `accessibilityRole` of `strong` to add more meaning to the text. |
| accessibilityRole? | <code>"address" &#124; "deletion" &#124; "marking" &#124; {type: "abbreviation", for?: string} &#124; {type: "directional-override", direction: "ltr" &#124; "rtl"} &#124; {type: "datetime", machineReadable?: string} &#124; "stress" &#124; "offset" &#124; "strong"</code> | Set the semantic of the component’s content<br /><br /><code>"address"</code>: Indicate the text is contact information. Typically used for addresses.<br /><br /><code>"deletion"</code>: Indicate the text has been deleted. Typically used for discounted prices.<br /><br /><code>"marking"</code>: Indicate the text is marked or highlighted and relevant to the buyer’s current action. Typically used to indicate the characters that matched a search query.<br /><br /><code>{type: "abbreviation", for?: string}</code>: Indicate the text is an abbreviation or acronym. Use the `for` option to provide a description of the abbreviation.<br /><br /><code>{type: "directional-override", direction: "ltr" &#124; "rtl"}</code>: Override the text directionality. Typically used for email and phone numbers.<br /><br /><code>{type: "datetime", machineReadable?: string}</code>: Indicate the text is a date, a time or a duration. Use the `machineReadable` option to help browsers, tools or software understand the human-readable date. The valid format for `machineReadable` can be found here: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/time#Valid_datetime_Values<br /><br /><code>"stress"</code>: Indicate emphatic stress. Typically for words that have a stressed emphasis compared to surrounding text. In an HTML host, the text will be rendered in a `<em>` tag.<br /><br /><code>"offset"</code>: Indicate an offset from the normal prose of the text. Typically used to indicate a foreign word, fictional character thoughts, or when the text refers to the definition of a word instead of representing its semantic meaning. In an HTML host, the text will be rendered in a `<i>` tag.<br /><br /><code>"strong"</code>: Indicate strong importance, seriousness, or urgency. In an HTML host, the text will be rendered in a `<strong>` tag. |
| id? | <code>string</code> | Unique identifier. Typically used as a target for another component’s controls to associate an accessible label with an action. |
| appearance? | <code>"accent" &#124; "subdued" &#124; "info" &#124; "success" &#124; "warning" &#124; "critical"</code> | Changes the visual appearance<br /><br /><code>"accent"</code>: Conveys emphasis and draws attention to the element.<br /><br /><code>"subdued"</code>: Conveys a subdued or disabled state for the element.<br /><br /><code>"info"</code>: Conveys that the element is informative or has information.<br /><br /><code>"success"</code>: Convey a successful interaction.<br /><br /><code>"warning"</code>: Convey something needs attention or an action needs to be taken.<br /><br /><code>"critical"</code>: Conveys a problem has arisen. |
| visibility? | <code>"hidden"</code> | Changes the visibility of the element.<br /><br />`hidden` visually hides the component while keeping it accessible to assistive technology, such as screen readers. Hidden elements don't take any visual space contrary to CSS visibility: hidden; |