import {ReferenceEntityTemplateSchema} from '@shopify/generate-docs';

const data: ReferenceEntityTemplateSchema = {
  name: 'Tooltip',
  description:
    'Tooltips are floating labels that briefly explain the function of a user interface element. They must be specified inside the `overlay` prop of an activator component. Currently, activator components are `Button`, `Link`, and `Pressable`.\n\nThe library takes care of applying the WAI-ARIA Tooltip Widget pattern automatically for the activator and the tooltip content. Expect screen readers to read the tooltip content when the user focuses the activator.',
  requires: '',
  thumbnail: 'tooltip-thumbnail.png',
  isVisualComponent: true,
  type: '',
  definitions: [
    {
      title: 'TooltipProps',
      description: '',
      type: 'TooltipProps',
    },
  ],
  category: 'Components',
  subCategory: 'Overlays',
  defaultExample: {
    image: 'tooltip-default.png',
    codeblock: {
      title: 'Basic Tooltip',
      tabs: [
        {
          title: 'React',
          code: '../../../../checkout-ui-extensions-react/src/components/Tooltip/examples/basic-tooltip.example.tsx',
          language: 'tsx',
        },
        {
          title: 'JS',
          code: './examples/basic-tooltip.example.ts',
          language: 'js',
        },
      ],
    },
  },
  related: [],
};

export default data;
