/**
 * Fetches secured content from the system's keychain.
 * @param identifier - Identifier to identify the content.
 * @returns A promise that resolves with the content or null if it doesn't exist.
 */
export declare function secureStoreFetch(identifier: string): Promise<string | null>;
/**
 * Securely stores the content under the given key.
 * @param identifier - Identifier to identify the content.
 * @param content - The content to be stored.
 * @returns A promise that resolves when the storing completes.
 */
export declare function secureStoreSave(identifier: string, content: string): Promise<void>;
/**
 * Removes the content with the given identifier.
 * @param identifier - Identifier to identify the content.
 * @returns A promise that resolves with true if the content was deleted.
 */
export declare function secureStoreRemove(identifier: string): Promise<boolean>;
