import { List } from './List.js';
import { unstyled } from '../../../../public/node/output.js';
import { describe, expect, test } from 'vitest';
import React from 'react';
import { render } from 'ink-testing-library';
describe('List', async () => {
    test('renders unordered items', async () => {
        const options = {
            title: 'List title',
            items: ['Item 1', 'Item 2', 'Item 3'],
            ordered: false,
        };
        const { lastFrame } = render(React.createElement(List, { ...options }));
        expect(unstyled(lastFrame())).toMatchInlineSnapshot(`
      "List title
        • Item 1
        • Item 2
        • Item 3"
    `);
    });
    test('renders ordered items', async () => {
        const options = {
            items: ['Item 1', 'Item 2', 'Item 3'],
            ordered: true,
        };
        const { lastFrame } = render(React.createElement(List, { ...options }));
        expect(unstyled(lastFrame())).toMatchInlineSnapshot(`
      "  1. Item 1
        2. Item 2
        3. Item 3"
    `);
    });
});
//# sourceMappingURL=List.test.js.map