import { SelectInput } from './SelectInput.js';
import { InfoTable } from './Prompts/InfoTable.js';
import { TokenizedText } from './TokenizedText.js';
import { handleCtrlC } from '../../ui.js';
import { messageWithPunctuation } from '../utilities.js';
import React, { useCallback, useState } from 'react';
import { Box, measureElement, Text, useApp, useInput, useStdout } from 'ink';
import figures from 'figures';
import ansiEscapes from 'ansi-escapes';
// eslint-disable-next-line react/function-component-definition
function SelectPrompt({ message, choices, infoTable, onSubmit, defaultValue, submitWithShortcuts = false, }) {
    if (choices.length === 0) {
        throw new Error('SelectPrompt requires at least one choice');
    }
    const initialValue = defaultValue ? choices.find((choice) => choice.value === defaultValue) ?? choices[0] : choices[0];
    const [answer, setAnswer] = useState(initialValue);
    const { exit: unmountInk } = useApp();
    const [submitted, setSubmitted] = useState(false);
    const { stdout } = useStdout();
    const [height, setHeight] = useState(0);
    const measuredRef = useCallback((node) => {
        if (node !== null) {
            const { height } = measureElement(node);
            setHeight(height);
        }
    }, []);
    const submitAnswer = useCallback((answer) => {
        if (stdout && height >= stdout.rows) {
            stdout.write(ansiEscapes.clearTerminal);
        }
        setSubmitted(true);
        unmountInk();
        onSubmit(answer.value);
    }, [stdout, stdout?.rows, height, onSubmit]);
    useInput(useCallback((input, key) => {
        handleCtrlC(input, key);
        if (key.return && answer) {
            submitAnswer(answer);
        }
    }, [answer, submitAnswer]));
    return (React.createElement(Box, { flexDirection: "column", marginBottom: 1, ref: measuredRef },
        React.createElement(Box, null,
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, null, "?")),
            React.createElement(TokenizedText, { item: messageWithPunctuation(message) })),
        infoTable && !submitted ? (React.createElement(Box, { marginLeft: 7, marginTop: 1 },
            React.createElement(InfoTable, { table: infoTable }))) : null,
        submitted ? (React.createElement(Box, null,
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, { color: "cyan" }, figures.tick)),
            React.createElement(Text, { color: "cyan" }, answer.label))) : (React.createElement(Box, { marginTop: 1 },
            React.createElement(SelectInput, { defaultValue: initialValue, items: choices, infoMessage: submitWithShortcuts
                    ? `Press ${figures.arrowUp}${figures.arrowDown} arrows to select, enter or a shortcut to confirm`
                    : undefined, onChange: ({ item, usedShortcut }) => {
                    setAnswer(item);
                    if (submitWithShortcuts && usedShortcut && item) {
                        submitAnswer(item);
                    }
                } })))));
}
export { SelectPrompt };
//# sourceMappingURL=SelectPrompt.js.map