import { unionArrayStrategy } from '../../private/common/array.js';
import deepMerge from 'deepmerge';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
/**
 * Deep merges the two objects and returns a new object with the merge result.
 *
 * @param lhs - One of the objects to be merged.
 * @param rhs - Another object to be merged.
 * @param arrayMergeStrategy - Strategy used to merge the array typed fields. Union strategy is used by default to avoid
 * duplicated elements.
 * @returns A Javascrip tobject with th emerged objects.
 */
export function deepMergeObjects(lhs, rhs, arrayMergeStrategy = unionArrayStrategy) {
    return deepMerge(lhs, rhs, { arrayMerge: arrayMergeStrategy });
}
/**
 * Creates an object composed of the `object` properties `predicate` returns
 * truthy for. The predicate is invoked with two arguments: (value, key).
 *
 * @param object - The source object.
 * @param predicate - The function invoked per property.
 * @returns Returns the new object.
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
export function pickBy(object, predicate) {
    const lodashPickBy = require('lodash/pickBy.js');
    return lodashPickBy(object, predicate);
}
/**
 * Creates an object with the same keys as object and values generated by running each own
 * enumerable property of object through iteratee. The iteratee function is
 * invoked with three arguments: (value, key, object).
 *
 * @param source - The object to iterate over.
 * @param callback -  The function invoked per iteration.
 * @returns Returns the new mapped object.
 */
export function mapValues(source, callback) {
    const lodashMapValues = require('lodash/mapValues.js');
    return lodashMapValues(source, callback);
}
//# sourceMappingURL=object.js.map