import React from 'react';
import { AppBridgeContext } from '../../../context';
export interface Props {
    /** Show/Dismiss loading spinner */
    loading: boolean;
}
/**
 * Modal Content component
 *
 * @remarks
 * React component which wraps the Shopify App Bridge Modal Content action.
 *
 * @public
 */
declare class ModalContent extends React.Component<Props> {
    static contextType: React.Context<import("../../../context").IAppBridgeContext>;
    context: React.ContextType<typeof AppBridgeContext>;
    private modalContent;
    componentDidMount(): void;
    componentDidUpdate(): void;
    syncLoadingStatus(): void;
    render(): null;
}
export default ModalContent;
