import type { Payload } from '@shopify/app-bridge/actions/Toast';
export declare const DEFAULT_TOAST_DURATION = 5000;
interface ShowOptionsPayload extends Payload {
    action?: {
        content: string;
        onAction?: () => void;
    };
}
/**
 * useToast hook
 *
 * @remarks
 * React hook which wraps the Shopify App Bridge Toast action.
 *
 * @public
 */
export declare function useToast(): {
    show: (content: string, options?: Partial<Omit<ShowOptionsPayload, "message">> | undefined) => void;
};
export {};
