import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
export declare enum Action {
    FETCH = "APP::CART::FETCH",
    UPDATE = "APP::CART::UPDATE",
    SET_CUSTOMER = "APP::CART::SET_CUSTOMER",
    REMOVE_CUSTOMER = "APP::CART::REMOVE_CUSTOMER",
    ADD_CUSTOMER_ADDRESS = "APP::CART::ADD_CUSTOMER_ADDRESS",
    UPDATE_CUSTOMER_ADDRESS = "APP::CART::UPDATE_CUSTOMER_ADDRESS",
    SET_DISCOUNT = "APP::CART::SET_DISCOUNT",
    REMOVE_DISCOUNT = "APP::CART::REMOVE_DISCOUNT",
    SET_PROPERTIES = "APP::CART::SET_PROPERTIES",
    REMOVE_PROPERTIES = "APP::CART::REMOVE_PROPERTIES",
    CLEAR = "APP::CART::CLEAR",
    ADD_LINE_ITEM = "APP::CART::ADD_LINE_ITEM",
    UPDATE_LINE_ITEM = "APP::CART::UPDATE_LINE_ITEM",
    REMOVE_LINE_ITEM = "APP::CART::REMOVE_LINE_ITEM",
    SET_LINE_ITEM_DISCOUNT = "APP::CART::SET_LINE_ITEM_DISCOUNT",
    REMOVE_LINE_ITEM_DISCOUNT = "APP::CART::REMOVE_LINE_ITEM_DISCOUNT",
    SET_LINE_ITEM_PROPERTIES = "APP::CART::SET_LINE_ITEM_PROPERTIES",
    REMOVE_LINE_ITEM_PROPERTIES = "APP::CART::REMOVE_LINE_ITEM_PROPERTIES"
}
export interface Data {
    cartDiscount?: Discount;
    customer?: CustomerWithAddresses;
    grandTotal?: string;
    lineItems?: LineItem[];
    noteAttributes?: NoteAttributes;
    subTotal?: string;
    taxTotal?: string;
}
export interface Payload {
    readonly data: Data;
    readonly id?: string;
}
export interface Options {
    readonly id?: string;
}
export interface AddCustomerAddressPayload {
    readonly data: Address;
    readonly id?: string;
}
export interface AddLineItemPayload {
    readonly data: LineItem;
    readonly id?: string;
}
export interface SetCustomerPayload {
    readonly data: Customer;
    readonly id?: string;
}
export interface UpdateCustomerAddressPayload {
    readonly data: Address;
    readonly index: number;
    readonly id?: string;
}
export interface SetDiscountPayload {
    readonly data: DiscountAmount | DiscountCode;
    readonly id?: string;
}
export interface SetPropertiesPayload {
    readonly data: Properties;
    readonly id?: string;
}
export interface RemovePropertiesPayload {
    readonly data: string[];
    readonly id?: string;
}
export interface UpdateLineItemData {
    quantity: number;
    readonly id?: string;
}
export interface UpdateLineItemPayload {
    readonly data: UpdateLineItemData;
    readonly index: number;
    readonly id?: string;
}
export interface RemoveLineItemPayload {
    readonly index: number;
    readonly id?: string;
}
export interface SetLineItemDiscountPayload {
    readonly data: DiscountAmount;
    readonly index: number;
    readonly id?: string;
}
export interface RemoveLineItemDiscountPayload {
    readonly index: number;
    readonly id?: string;
}
export interface SetLineItemPropertiesPayload {
    readonly data: Properties;
    readonly index: number;
    readonly id?: string;
}
export interface RemoveLineItemPropertiesPayload {
    readonly data: string[];
    readonly index: number;
    readonly id?: string;
}
/**
 * Cart types
 */
export interface Customer {
    id?: number;
    email?: string;
    firstName?: string;
    lastName?: string;
    note?: string;
}
export interface CustomerWithAddresses extends Customer {
    addresses?: Address[];
}
export interface Address {
    address1?: string;
    address2?: string;
    city?: string;
    company?: string;
    firstName?: string;
    lastName?: string;
    phone?: string;
    province?: string;
    country?: string;
    zip?: string;
    name?: string;
    provinceCode?: string;
    countryCode?: string;
}
export interface DiscountAmount {
    amount: number;
    discountDescription?: string;
    type?: string;
}
export interface DiscountCode {
    discountCode: string;
}
export interface Discount extends DiscountAmount, DiscountCode {
}
export interface LineItem {
    price?: number;
    quantity: number;
    title?: string;
    variantId?: number;
    discount?: DiscountAmount;
    properties?: NoteAttributes;
    taxable?: boolean;
}
export declare type NoteAttributes = {
    name: string;
    value: string;
}[];
export interface Properties {
    [index: string]: string;
}
export declare function fetch(): any;
export declare function update(payload: Payload): any;
export declare function setCustomer(payload: SetCustomerPayload): any;
export declare function addCustomerAddress(payload: AddCustomerAddressPayload): any;
export declare function updateCustomerAddress(payload: UpdateCustomerAddressPayload): any;
export declare function setDiscount(payload: SetDiscountPayload): any;
export declare function setProperties(payload: SetPropertiesPayload): any;
export declare function removeProperties(payload: RemovePropertiesPayload): any;
export declare function addLineItem(payload: AddLineItemPayload): any;
export declare function updateLineItem(payload: UpdateLineItemPayload): any;
export declare function removeLineItem(payload: RemoveLineItemPayload): any;
export declare function setLineItemDiscount(payload: SetLineItemDiscountPayload): any;
export declare function removeLineItemDiscount(payload: RemoveLineItemDiscountPayload): any;
export declare function setLineItemProperties(payload: SetLineItemPropertiesPayload): any;
/**
 * Cart
 */
export declare class Cart extends ActionSet {
    constructor(app: ClientApplication, options?: Options);
    dispatch(action: Action.FETCH | Action.REMOVE_CUSTOMER | Action.REMOVE_DISCOUNT | Action.CLEAR): Cart;
    dispatch(action: Action.UPDATE, payload: Payload): Cart;
    dispatch(action: Action.SET_CUSTOMER, payload: SetCustomerPayload): Cart;
    dispatch(action: Action.ADD_CUSTOMER_ADDRESS, payload: AddCustomerAddressPayload): Cart;
    dispatch(action: Action.UPDATE_CUSTOMER_ADDRESS, payload: UpdateCustomerAddressPayload): Cart;
    dispatch(action: Action.SET_DISCOUNT, payload: SetDiscountPayload): Cart;
    dispatch(action: Action.SET_PROPERTIES, payload: SetPropertiesPayload): Cart;
    dispatch(action: Action.REMOVE_PROPERTIES, payload: RemovePropertiesPayload): Cart;
    dispatch(action: Action.ADD_LINE_ITEM, payload: AddLineItemPayload): Cart;
    dispatch(action: Action.UPDATE_LINE_ITEM, payload: UpdateLineItemPayload): Cart;
    dispatch(action: Action.REMOVE_LINE_ITEM, payload: RemoveLineItemPayload): Cart;
    dispatch(action: Action.SET_LINE_ITEM_DISCOUNT, payload: SetLineItemDiscountPayload): Cart;
    dispatch(action: Action.REMOVE_LINE_ITEM_DISCOUNT, payload: RemoveLineItemDiscountPayload): Cart;
    dispatch(action: Action.SET_LINE_ITEM_PROPERTIES, payload: SetLineItemPropertiesPayload): Cart;
    dispatch(action: Action.REMOVE_LINE_ITEM_PROPERTIES, payload: RemoveLineItemPropertiesPayload): Cart;
    private dispatchCartAction;
}
export declare function create(app: ClientApplication, options?: Options): Cart;
