import { Button, Payload as ButtonPayload } from '../Button';
import { ClientApplication } from '../../client';
import { ActionSetWithChildren } from '../ActionSet';
import { ActionSetProps, ClickAction, Group, MetaAction } from '../types';
export declare enum Action {
    UPDATE = "APP::MARKETING_EXTERNAL_ACTIVITY_TOP_BAR::UPDATE",
    BUTTON_CLICK = "APP::MARKETING_EXTERNAL_ACTIVITY_TOP_BAR::BUTTONS::BUTTON::CLICK",
    BUTTON_UPDATE = "APP::MARKETING_EXTERNAL_ACTIVITY_TOP_BAR::BUTTONS::BUTTON::UPDATE"
}
export interface ButtonsOptions {
    primary?: Button;
    secondary?: Button[];
}
export declare enum MarketingActivityStatusBadgeType {
    Default = "DEFAULT",
    Success = "SUCCESS",
    Attention = "ATTENTION",
    Warning = "WARNING",
    Info = "INFO"
}
export interface Status {
    label: string;
    badgeType: MarketingActivityStatusBadgeType;
}
export declare type StatusPayload = Status;
export interface Options {
    title?: string;
    saving?: boolean;
    saved?: boolean;
    status?: Status;
    buttons?: ButtonsOptions;
}
export interface ButtonsPayload {
    primary?: ButtonPayload;
    secondary?: ButtonPayload[];
}
export interface Payload {
    readonly id?: string;
    title?: string;
    saving?: boolean;
    saved?: boolean;
    status?: StatusPayload;
    buttons?: ButtonsPayload;
}
export interface UpdateAction extends MetaAction {
    readonly group: typeof Group.MarketingExternalActivityTopBar;
    payload: Payload;
}
export declare type MarketingExternalActivityTopBarAction = UpdateAction | ClickAction | MetaAction;
export declare function clickActionButton(id: string, payload?: any): ClickAction;
export declare function update(payload: Payload): UpdateAction;
export declare class MarketingExternalActivityTopBar extends ActionSetWithChildren implements ActionSetProps<Options, Payload> {
    title?: string;
    primary?: ButtonPayload;
    secondary?: ButtonPayload[];
    primaryOptions?: Button;
    secondaryOptions?: Button[];
    saving?: boolean;
    saved?: boolean;
    status?: Status;
    constructor(app: ClientApplication, options: Options);
    get buttons(): ButtonsPayload | undefined;
    get buttonsOptions(): ButtonsOptions | undefined;
    get options(): Options;
    get payload(): Payload;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action): this;
    protected getButton(button: Button, subgroups: string[], updateCb: (newPayload: ButtonPayload) => void): ButtonPayload;
    protected updatePrimaryButton(newPayload: ButtonPayload): void;
    protected updateSecondaryButtons(newPayload: ButtonPayload): void;
    protected setPrimaryButton(newOptions?: Button): void;
    protected setSecondaryButtons(newOptions?: Button[]): void;
    protected updateSaving(saving: boolean): void;
    protected updateSaved(saved: boolean): void;
    protected updateStatus(newPayload: StatusPayload): void;
    protected getChildButton(newAction: undefined | Button, currentAction: undefined | Button): Button | undefined;
}
export declare function create(app: ClientApplication, options: Options): MarketingExternalActivityTopBar;
