import { ClientApplication } from '../../client';
import { ActionSetWithChildren } from '../ActionSet';
import { ActionSetProps, ClickAction, Group, MetaAction } from '../types';
import { Button, Payload as ButtonPayload } from '../Button';
export declare enum Action {
    OPEN = "APP::MODAL::OPEN",
    CLOSE = "APP::MODAL::CLOSE",
    UPDATE = "APP::MODAL::UPDATE",
    UPDATE_CONTENT = "APP::MODAL::CONTENT::UPDATE",
    FOOTER_BUTTON_CLICK = "APP::MODAL::FOOTER::BUTTON::CLICK",
    FOOTER_BUTTON_UPDATE = "APP::MODAL::FOOTER::BUTTON::UPDATE",
    UPDATE_SIZE = "APP::MODAL::UPDATE_SIZE",
    DATA = "APP::MODAL::DATA"
}
/**
 * Options available to the Modal `size` param
 * @public
 */
export declare enum Size {
    /** Small modal size */
    Small = "small",
    /** Medium modal size */
    Medium = "medium",
    /** Large modal size (wider than medium) */
    Large = "large",
    /** @deprecated as of 1.6.5 */
    Full = "full",
    /**
     * @deprecated as of 1.12.x
     * @remarks
     * This option has been removed in favour of the `setUpModalAutoSizing` utility.
     */
    Auto = "auto"
}
export interface BasePayload {
    readonly id?: string;
    size?: Size;
    title?: string;
    footer?: Footer;
}
export interface MessagePayload extends BasePayload {
    message: string;
}
export interface IframePayload extends BasePayload {
    url?: string;
    path?: string;
    loading?: boolean;
}
/**
 * Payload interface for APP::MODAL::UPDATE_SIZE action
 * @internal
 */
export interface UpdateSizePayload {
    readonly id?: string;
    /** desired modal height in px, no suffix */
    readonly height?: string;
}
export interface ClosePayload {
    readonly id?: string;
}
export interface FooterOptions {
    buttons: {
        primary?: Button;
        secondary?: Button[];
    };
}
export interface Footer {
    buttons: {
        primary?: ButtonPayload;
        secondary?: ButtonPayload[];
    };
}
export interface MessageOptions extends MessagePayload {
    footer?: FooterOptions;
}
export interface IframeOptions extends IframePayload {
    footer?: FooterOptions;
}
export interface ModalDataPayload {
    [key: string]: any;
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.Modal;
}
export interface OpenAction extends ActionBase {
    readonly type: typeof Action.OPEN;
    readonly payload: MessagePayload | IframePayload;
}
export declare type UpdateAction = OpenAction;
export interface CloseAction extends ActionBase {
    readonly type: typeof Action.CLOSE;
}
/**
 * Payload options for APP::MODAL::UPDATE_SIZE action
 * @public
 */
export interface UpdateSizeAction extends ActionBase {
    readonly payload: UpdateSizePayload;
}
/**
 * @internal
 */
export declare type ModalAction = OpenAction | UpdateAction | CloseAction | MetaAction | UpdateSizeAction;
export declare function openModal(modalPayload: MessagePayload | IframePayload): OpenAction;
export declare function closeModal(modalClosePayload: ClosePayload): CloseAction;
/**
 * Action creator for modal update size action
 * @internal
 */
export declare function updateModalSize(updateSizePayload: UpdateSizePayload): UpdateSizeAction;
export declare function clickFooterButton(id: string, payload?: any): ClickAction;
export declare function update(payload: MessagePayload | IframePayload): UpdateAction;
export declare function data(payload: ModalDataPayload): UpdateAction;
export declare function isIframeModal(options: MessagePayload | IframePayload | object): options is IframePayload;
export declare function isMessageModal(options: MessagePayload | IframePayload | object): options is MessagePayload;
export declare abstract class Modal extends ActionSetWithChildren {
    title?: string;
    size: Size;
    footerPrimary?: ButtonPayload;
    footerPrimaryOptions?: Button;
    footerSecondary?: ButtonPayload[];
    footerSecondaryOptions?: Button[];
    get footer(): Footer | undefined;
    get footerOptions(): FooterOptions | undefined;
    protected close(): void;
    protected setFooterPrimaryButton(newOptions: Button | undefined, updateCb: () => void): void;
    protected setFooterSecondaryButtons(newOptions: Button[] | undefined, updateCb: () => void): void;
    protected getChildButton(newAction: undefined | Button, currentAction: undefined | Button): Button | undefined;
    protected updatePrimaryFooterButton(newPayload: ButtonPayload, updateCb: () => void): void;
    protected updateSecondaryFooterButton(newPayload: ButtonPayload, updateCb: () => void): void;
}
export declare class ModalMessage extends Modal implements ActionSetProps<MessageOptions, MessagePayload> {
    message: string;
    constructor(app: ClientApplication, options: MessageOptions);
    get payload(): {
        footer: Footer | undefined;
        id: string;
        message: string;
        size: Size;
        title: string | undefined;
    };
    get options(): {
        footer: FooterOptions | undefined;
        message: string;
        size: Size;
        title: string | undefined;
    };
    set(options: Partial<MessageOptions>, shouldUpdate?: boolean): this;
    dispatch(action: Action): this;
}
export declare class ModalIframe extends Modal implements ActionSetProps<IframeOptions, IframePayload> {
    url?: string;
    path?: string;
    loading?: boolean;
    constructor(app: ClientApplication, options: IframeOptions);
    get payload(): {
        footer: Footer | undefined;
        id: string;
        path: string | undefined;
        size: Size;
        title: string | undefined;
        url: string | undefined;
        loading: boolean | undefined;
    };
    get options(): {
        footer: FooterOptions | undefined;
        path: string | undefined;
        size: Size;
        title: string | undefined;
        url: string | undefined;
        loading: boolean | undefined;
    };
    set(options: Partial<IframeOptions>, shouldUpdate?: boolean): this;
    dispatch(action: Action, payload?: ModalDataPayload): this;
}
export declare const create: (app: ClientApplication, options: MessageOptions | IframeOptions) => ModalMessage | ModalIframe;
