import { ClientApplication } from '../../../client';
import { ActionSet } from '../../ActionSet';
import { ComplexDispatch, Group, MetaAction } from '../../types';
export interface BasePayload {
    id?: string;
}
export interface BaseAdminPayload extends BasePayload {
    newContext?: boolean;
}
export interface AppPayload extends BasePayload {
    path: string;
}
export interface AdminPathPayload extends BaseAdminPayload {
    path: string;
}
export interface RemotePayload extends BaseAdminPayload {
    url: string;
}
export interface CreateResource {
    create: boolean;
}
export interface ResourceInfo {
    id: string;
}
export interface Section {
    name: ResourceType;
    resource?: CreateResource | ResourceInfo | ProductVariantResource;
}
export interface AdminSectionPayload extends BaseAdminPayload {
    section: Section;
}
export interface ProductVariantResource extends ResourceInfo {
    variant: CreateResource | ResourceInfo;
}
export declare enum Action {
    ADMIN_SECTION = "APP::NAVIGATION::REDIRECT::ADMIN::SECTION",
    ADMIN_PATH = "APP::NAVIGATION::REDIRECT::ADMIN::PATH",
    REMOTE = "APP::NAVIGATION::REDIRECT::REMOTE",
    APP = "APP::NAVIGATION::REDIRECT::APP"
}
export declare enum ResourceType {
    Product = "products",
    Collection = "collections",
    Order = "orders",
    Customer = "customers",
    Discount = "discounts"
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.Navigation;
}
export interface AdminPathAction extends ActionBase {
    readonly type: typeof Action.ADMIN_PATH;
    readonly payload: AdminPathPayload;
}
export interface AdminSectionAction extends ActionBase {
    readonly type: typeof Action.ADMIN_SECTION;
    readonly payload: AdminSectionPayload;
}
export interface AppAction extends ActionBase {
    readonly type: typeof Action.APP;
    readonly payload: AdminPathPayload;
}
export interface RemoteAction extends ActionBase {
    readonly type: typeof Action.REMOTE;
    readonly payload: RemotePayload;
}
export declare type RedirectAction = AdminPathAction | RemoteAction | AppAction | AdminSectionAction | MetaAction;
export interface Location {
    pathname: string;
    search?: string | URLSearchParams;
    hash?: string;
}
export interface AppOptions {
    replace?: boolean;
    target?: 'self';
}
export interface HostOptions {
    target: 'host' | 'new';
}
export declare type Options = AppOptions | HostOptions;
export declare type To = Location | URL | string;
export interface SectionStringName extends Omit<Section, 'name'> {
    name: keyof typeof ResourceType;
}
export interface Navigate<T = To> {
    (to: T, options?: AppOptions): void;
    (to: T | SectionStringName, options?: HostOptions): void;
}
export declare function isResourcePayload(resource: ResourceInfo | object): resource is ResourceInfo;
export declare function isCreateResourcePayload(resource: CreateResource | object): resource is CreateResource;
export declare function isProductVariantResourcePayload(resource: ProductVariantResource | object): resource is ProductVariantResource;
export declare function isProductVariantCreateResourcePayload(resource: ProductVariantResource | object): resource is ProductVariantResource & {
    variant: CreateResource;
};
export declare function toAdminPath(payload: AdminPathPayload): AdminPathAction;
export declare function toAdminSection(payload: AdminSectionPayload): AdminSectionAction;
export declare function toRemote(payload: RemotePayload): RemoteAction;
export declare function toApp(payload: AppPayload): AppAction;
export declare function toDestination(action: Action, payload: any, id?: string): AdminPathAction | AdminSectionAction | AppAction | RemoteAction;
export declare function getPathWithSearchAndHash({ pathname, search, hash }: Location): string;
export declare function normalizeUrl(to: To): string;
export declare function getRelativePath(to: To): string;
export declare function isAppPayload(payload: any): payload is AppPayload;
export declare function isAdminPathPayload(payload: any): payload is AdminPathPayload;
export declare function isAdminSectionPayload(payload: any): payload is AdminSectionPayload;
export declare function isRemotePayload(payload: any): payload is RemotePayload;
export declare function isAdminSection(to: any): to is SectionStringName;
export declare class Redirect extends ActionSet implements ComplexDispatch<Section | string> {
    constructor(app: ClientApplication);
    get payload(): {
        id: string;
    };
    dispatch(action: Action.ADMIN_SECTION, payload: Section | AdminSectionPayload): ActionSet;
    dispatch(action: Action.ADMIN_PATH, payload: string | AdminPathPayload): ActionSet;
    dispatch(action: Action.REMOTE, payload: string | RemotePayload): ActionSet;
    dispatch(action: Action.APP, payload: string): ActionSet;
}
export declare function create(app: ClientApplication): Redirect;
