import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
import { MetaAction } from '../types';
/**
 * Action Types for the Features group
 * @public
 */
export declare enum Action {
    OPEN_CAMERA = "APP::SCANNER::OPEN::CAMERA",
    CAPTURE = "APP::SCANNER::CAPTURE"
}
/**
 * Payload for APP::SCANNER::CAPTURE
 * @public
 */
export interface Data {
    scanData?: string;
}
export interface Payload {
    readonly data: Data;
}
export interface Options {
    readonly id?: string;
}
/**
 * A set of Actions for displaying a Camera Scanner component
 * @public
 */
export declare class Scanner extends ActionSet {
    constructor(app: ClientApplication, options?: Options);
    /**
     * @public
     */
    dispatch(action: Action.OPEN_CAMERA): Scanner;
    /**
     * @internal
     */
    private dispatchScannerAction;
}
/**
 * @public
 */
export declare function create(app: ClientApplication, options?: Options): Scanner;
export declare type ScannerAction = MetaAction;
export declare function openCamera(): ScannerAction;
export declare function capture(payload: Payload & Options): ScannerAction;
