'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../../../utilities/css.js');
var setRootProperty = require('../../../../utilities/set-root-property.js');
var IndexTable = require('../../IndexTable.scss.js');
var Checkbox$1 = require('./Checkbox.scss.js');
var hooks$1 = require('../../../../utilities/index-provider/hooks.js');
var context = require('../../../../utilities/index-table/context.js');
var hooks = require('../../../../utilities/i18n/hooks.js');
var Checkbox$2 = require('../../../Checkbox/Checkbox.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const Checkbox = /*#__PURE__*/React.memo(function Checkbox() {
  const i18n = hooks.useI18n();
  const {
    resourceName,
    condensed
  } = hooks$1.useIndexValue();
  const {
    itemId,
    selected,
    disabled,
    onInteraction
  } = React.useContext(context.RowContext);
  const wrapperClassName = css.classNames(Checkbox$1["default"].Wrapper, condensed ? Checkbox$1["default"].condensed : Checkbox$1["default"].expanded);
  const Wrapper = condensed ? React.Fragment : CheckboxWrapper;
  return /*#__PURE__*/React__default["default"].createElement(Wrapper, null, /*#__PURE__*/React__default["default"].createElement("div", {
    className: Checkbox$1["default"].TableCellContentContainer
  }, /*#__PURE__*/React__default["default"].createElement("div", {
    className: wrapperClassName,
    onClick: onInteraction,
    onKeyUp: noop
  }, /*#__PURE__*/React__default["default"].createElement(Checkbox$2.Checkbox, {
    id: itemId,
    label: i18n.translate('Polaris.IndexTable.selectItem', {
      resourceName: resourceName.singular
    }),
    labelHidden: true,
    checked: selected,
    disabled: disabled
  }))));
});
function CheckboxWrapper({
  children
}) {
  const checkboxNode = React.useRef(null);
  const handleResize = React.useCallback(() => {
    if (!checkboxNode.current) return;
    const {
      width
    } = checkboxNode.current.getBoundingClientRect();
    setRootProperty.setRootProperty('--pc-checkbox-offset', `${width}px`);
  }, []);
  React.useEffect(() => {
    handleResize();
  }, [handleResize]);
  React.useEffect(() => {
    if (!checkboxNode.current) return;
    window.addEventListener('resize', handleResize);
    return () => {
      window.removeEventListener('resize', handleResize);
    };
  }, [handleResize]);
  const checkboxClassName = css.classNames(IndexTable["default"].TableCell, IndexTable["default"]['TableCell-first']);
  return /*#__PURE__*/React__default["default"].createElement("td", {
    className: checkboxClassName,
    ref: checkboxNode
  }, children);
}

function noop() {}

exports.Checkbox = Checkbox;
exports.CheckboxWrapper = CheckboxWrapper;
