'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactTransitionGroup = require('react-transition-group');
var polarisTokens = require('@shopify/polaris-tokens');
var css = require('../../utilities/css.js');
var ProgressBar$1 = require('./ProgressBar.scss.js');
var hooks = require('../../utilities/i18n/hooks.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function ProgressBar({
  progress = 0,
  size = 'medium',
  color = 'highlight',
  animated: hasAppearAnimation = true
}) {
  const i18n = hooks.useI18n();
  const className = css.classNames(ProgressBar$1["default"].ProgressBar, size && ProgressBar$1["default"][css.variationName('size', size)], color && ProgressBar$1["default"][css.variationName('color', color)]);
  const warningMessage = i18n.translate(progress < 0 ? 'Polaris.ProgressBar.negativeWarningMessage' : 'Polaris.ProgressBar.exceedWarningMessage', {
    progress
  });
  const parsedProgress = parseProgress(progress, warningMessage);
  const progressBarDuration = hasAppearAnimation ? polarisTokens.tokens.motion['duration-500'].value : polarisTokens.tokens.motion['duration-0'].value;
  /* eslint-disable @shopify/jsx-no-hardcoded-content */

  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: className
  }, /*#__PURE__*/React__default["default"].createElement("progress", {
    className: ProgressBar$1["default"].Progress,
    value: parsedProgress,
    max: "100"
  }), /*#__PURE__*/React__default["default"].createElement(reactTransitionGroup.CSSTransition, {
    in: true,
    appear: true,
    timeout: parseInt(progressBarDuration, 10),
    classNames: {
      appearActive: ProgressBar$1["default"].IndicatorAppearActive,
      appearDone: ProgressBar$1["default"].IndicatorAppearDone
    }
  }, /*#__PURE__*/React__default["default"].createElement("div", {
    className: ProgressBar$1["default"].Indicator,
    style: {
      '--pc-progress-bar-duration': progressBarDuration,
      '--pc-progress-bar-percent': parsedProgress / 100
    }
  }, /*#__PURE__*/React__default["default"].createElement("span", {
    className: ProgressBar$1["default"].Label
  }, parsedProgress, "%"))))
  /* eslint-enable @shopify/jsx-no-hardcoded-content */
  ;
}

function parseProgress(progress, warningMessage) {
  let progressWidth;

  if (progress < 0) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(warningMessage);
    }

    progressWidth = 0;
  } else if (progress > 100) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn(warningMessage);
    }

    progressWidth = 100;
  } else {
    progressWidth = progress;
  }

  return progressWidth;
}

exports.ProgressBar = ProgressBar;
