import { IconSource } from '../../types';
import { Progress, Size, Status } from './types';
interface NonMutuallyExclusiveProps {
    /** The content to display inside the badge. */
    children?: string;
    /** Colors and labels the badge with the given status. */
    status?: Status;
    /** Render a pip showing the progress of a given task. */
    progress?: Progress;
    /** Icon to display to the left of the badge’s content. */
    icon?: IconSource;
    /**
     * Medium or small size.
     * @default 'medium'
     */
    size?: Size;
    /** Pass a custom accessibilityLabel */
    statusAndProgressLabelOverride?: string;
}
export declare type BadgeProps = NonMutuallyExclusiveProps & ({
    progress?: Progress;
    icon?: undefined;
} | {
    icon?: IconSource;
    progress?: undefined;
});
export declare function Badge({ children, status, progress, icon, size, statusAndProgressLabelOverride, }: BadgeProps): JSX.Element;
export declare namespace Badge {
    var Pip: typeof import("./components").Pip;
}
export {};
//# sourceMappingURL=Badge.d.ts.map
