import { Options, Plugin as IPlugin } from '../interfaces/plugin';
import { Config as IConfig, ArchTypes, PlatformTypes, LoadOptions } from '../interfaces/config';
import { Command, Hook, Hooks, PJSON, Topic } from '../interfaces';
import * as Plugin from './plugin';
export declare class Config implements IConfig {
    options: Options;
    _base: string;
    name: string;
    version: string;
    channel: string;
    root: string;
    arch: ArchTypes;
    bin: string;
    cacheDir: string;
    configDir: string;
    dataDir: string;
    dirname: string;
    errlog: string;
    home: string;
    platform: PlatformTypes;
    shell: string;
    windows: boolean;
    userAgent: string;
    debug: number;
    npmRegistry?: string;
    pjson: PJSON.CLI;
    userPJSON?: PJSON.User;
    plugins: IPlugin[];
    binPath?: string;
    valid: boolean;
    topicSeparator: ':' | ' ';
    flexibleTaxonomy: boolean;
    protected warned: boolean;
    private commandPermutations;
    private topicPermutations;
    private _commands;
    private _topics;
    private _commandIDs;
    constructor(options: Options);
    static load(opts?: LoadOptions): Promise<IConfig | Config>;
    load(): Promise<void>;
    loadCorePlugins(): Promise<void>;
    loadDevPlugins(): Promise<void>;
    loadUserPlugins(): Promise<void>;
    runHook<T extends keyof Hooks>(event: T, opts: Hooks[T]['options'], timeout?: number): Promise<Hook.Result<Hooks[T]['return']>>;
    runCommand<T = unknown>(id: string, argv?: string[], cachedCommand?: Command.Loadable): Promise<T>;
    scopedEnvVar(k: string): string | undefined;
    scopedEnvVarTrue(k: string): boolean;
    scopedEnvVarKey(k: string): string;
    findCommand(id: string, opts: {
        must: true;
    }): Command.Loadable;
    findCommand(id: string, opts?: {
        must: boolean;
    }): Command.Loadable | undefined;
    findTopic(id: string, opts: {
        must: true;
    }): Topic;
    findTopic(id: string, opts?: {
        must: boolean;
    }): Topic | undefined;
    /**
     * Find all command ids that include the provided command id.
     *
     * For example, if the command ids are:
     * - foo:bar:baz
     * - one:two:three
     *
     * `bar` would return `foo:bar:baz`
     *
     * @param partialCmdId string
     * @param argv string[] process.argv containing the flags and arguments provided by the user
     * @returns string[]
     */
    findMatches(partialCmdId: string, argv: string[]): Command.Loadable[];
    /**
     * Returns an array of all commands. If flexible taxonomy is enabled then all permutations will be appended to the array.
     * @returns Command.Loadable[]
     */
    getAllCommands(): Command.Loadable[];
    /**
     * Returns an array of all command ids. If flexible taxonomy is enabled then all permutations will be appended to the array.
     * @returns string[]
     */
    getAllCommandIDs(): string[];
    get commands(): Command.Loadable[];
    get commandIDs(): string[];
    get topics(): Topic[];
    s3Key(type: keyof PJSON.S3.Templates, ext?: '.tar.gz' | '.tar.xz' | IConfig.s3Key.Options, options?: IConfig.s3Key.Options): string;
    s3Url(key: string): string;
    protected dir(category: 'cache' | 'data' | 'config'): string;
    protected windowsHome(): string | undefined;
    protected windowsHomedriveHome(): string | undefined;
    protected windowsUserprofileHome(): string | undefined;
    protected macosCacheDir(): string | undefined;
    protected _shell(): string;
    protected _debug(): number;
    protected loadPlugins(root: string, type: string, plugins: (string | {
        root?: string;
        name?: string;
        tag?: string;
    })[], parent?: Plugin.Plugin): Promise<void>;
    protected warn(err: string | Error | {
        name: string;
        detail: string;
    }, scope?: string): void;
    protected get isProd(): boolean;
    private getCmdLookupId;
    private getTopicLookupId;
    private loadCommands;
    private loadTopics;
    /**
     * This method is responsible for locating the correct plugin to use for a named command id
     * It searches the {Config} registered commands to match either the raw command id or the command alias
     * It is possible that more than one command will be found. This is due the ability of two distinct plugins to
     * create the same command or command alias.
     *
     * In the case of more than one found command, the function will select the command based on the order in which
     * the plugin is included in the package.json `oclif.plugins` list. The command that occurs first in the list
     * is selected as the command to run.
     *
     * Commands can also be present from either an install or a link. When a command is one of these and a core plugin
     * is present, this function defers to the core plugin.
     *
     * If there is not a core plugin command present, this function will return the first
     * plugin as discovered (will not change the order)
     *
     * @param commands commands to determine the priority of
     * @returns command instance {Command.Loadable} or undefined
     */
    private determinePriority;
}
export declare function toCached(c: Command.Class, plugin?: IPlugin): Promise<Command>;
