import { selectApp } from './select-app.js';
import { getURLs, updateURLs, validatePartnersURLs } from '../dev/urls.js';
import { allowedRedirectionURLsPrompt, appUrlPrompt } from '../../prompts/update-url.js';
import { ensureAuthenticatedPartners } from '@shopify/cli-kit/node/session';
import { renderSuccess } from '@shopify/cli-kit/node/ui';
export default async function updateURL(options) {
    const token = await ensureAuthenticatedPartners();
    const apiKey = options.apiKey || (await selectApp()).apiKey;
    const newURLs = await getNewURLs(token, apiKey, { appURL: options.appURL, redirectURLs: options.redirectURLs });
    await updateURLs(newURLs, apiKey, token);
    printResult(newURLs);
}
async function getNewURLs(token, apiKey, options) {
    const currentURLs = await getURLs(apiKey, token);
    const newURLs = {
        applicationUrl: options.appURL || (await appUrlPrompt(currentURLs.applicationUrl)),
        redirectUrlWhitelist: options.redirectURLs || (await allowedRedirectionURLsPrompt(currentURLs.redirectUrlWhitelist.join(','))),
    };
    validatePartnersURLs(newURLs);
    return newURLs;
}
function printResult(urls) {
    renderSuccess({
        headline: 'App URLs updated',
        customSections: [
            { title: 'App URL', body: { list: { items: [urls.applicationUrl] } } },
            { title: 'Allowed redirection URL(s)', body: { list: { items: urls.redirectUrlWhitelist } } },
        ],
    });
}
//# sourceMappingURL=update-url.js.map