import { Conf } from '@shopify/cli-kit/node/conf';
export interface CachedAppInfo {
    directory: string;
    appId?: string;
    title?: string;
    orgId?: string;
    storeFqdn?: string;
    updateURLs?: boolean;
    tunnelPlugin?: string;
}
export interface AppConfSchema {
    [key: string]: CachedAppInfo;
}
export declare function getAppInfo(directory: string, config?: Conf<AppConfSchema>): CachedAppInfo | undefined;
export declare function clearAppInfo(directory: string, config?: Conf<AppConfSchema>): void;
export declare function clearAllAppInfo(config?: Conf<AppConfSchema>): void;
export declare function setAppInfo(options: CachedAppInfo, config?: Conf<AppConfSchema>): void;
