import { AppInterface } from '../../models/app/app.js';
import { Config } from '@oclif/core';
export interface PartnersURLs {
    applicationUrl: string;
    redirectUrlWhitelist: string[];
}
export interface FrontendURLOptions {
    app: AppInterface;
    tunnel: boolean;
    noTunnel: boolean;
    tunnelUrl?: string;
    cachedTunnelPlugin?: string;
    commandConfig: Config;
}
export interface FrontendURLResult {
    frontendUrl: string;
    frontendPort: number;
    usingLocalhost: boolean;
}
/**
 * The tunnel creation logic depends on 7 variables:
 * - If a Codespaces environment is deteced, then the URL is built using the codespaces hostname. No need for tunnel
 * - If a Gitpod environment is detected, then the URL is built using the gitpod hostname. No need for tunnel
 * - If a Spin environment is detected, then the URL is built using the cli + fqdn hostname as configured in nginx.
 *   No need for tunnel. In case problems with that configuration, the flags Tunnel or Custom Tunnel url could be used
 * - If a tunnelUrl is provided, that takes preference and is returned as the frontendURL
 * - If noTunnel is true, that takes second preference and localhost is used
 * - A Tunnel is created then if any of these conditions are met:
 *   - Tunnel flag is true
 *   - The app has UI extensions
 *   - In a previous run, the user selected to always use a tunnel (cachedTunnelPlugin)
 * - Otherwise, localhost is used
 *
 * If there is no cached tunnel plugin and a tunnel is necessary, we'll ask the user to confirm.
 */
export declare function generateFrontendURL(options: FrontendURLOptions): Promise<FrontendURLResult>;
export declare function generateURL(config: Config, frontendPort: number): Promise<string>;
export declare function generatePartnersURLs(baseURL: string, authCallbackPath?: string | string[]): PartnersURLs;
export declare function updateURLs(urls: PartnersURLs, apiKey: string, token: string): Promise<void>;
export declare function getURLs(apiKey: string, token: string): Promise<PartnersURLs>;
export interface ShouldOrPromptUpdateURLsOptions {
    currentURLs: PartnersURLs;
    appDirectory: string;
    cachedUpdateURLs?: boolean;
    newApp?: boolean;
}
export declare function shouldOrPromptUpdateURLs(options: ShouldOrPromptUpdateURLsOptions): Promise<boolean>;
export declare function validatePartnersURLs(urls: PartnersURLs): void;
