export declare const DELIVERY_METHOD: {
    LOCALHOST: string;
    HTTP: string;
    PUBSUB: string;
    EVENTBRIDGE: string;
};
/**
 * Detect which delivery-method an address belongs to
 *
 * @param address - A target endpoint
 * @returns A DELIVERY_METHOD or undefined if none found
 */
export declare function deliveryMethodForAddress(address: string): string | undefined;
/**
 * Checks whether an address and a delivery method are compatible
 *
 * @param address - A target endpoint
 * @param deliveryMethod - An existing delivery-method
 * @returns true if compatible (eg: pubsub://projectid/topicid and google-pub-sub), false otherwise
 */
export declare function isAddressAllowedForDeliveryMethod(address: string, deliveryMethod: string): boolean;
