'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `shippingAddress` applied to the checkout.
 */
function useShippingAddress() {
  const shippingAddress = api.useExtensionApi().shippingAddress;
  if (!shippingAddress) {
    throw new errors.ScopeNotGrantedError('Using shipping address requires having shipping address permissions granted to your app.');
  }
  return subscription.useSubscription(shippingAddress);
}

exports.useShippingAddress = useShippingAddress;
