import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current language of the checkout, and automatically re-renders
 * your component if the language changes.
 */
function useLanguage() {
  const {
    localization
  } = useExtensionApi();
  return useSubscription(localization.language);
}

export { useLanguage };
