import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the proposed `note` applied to the checkout.
 */
function useNote() {
  return useSubscription(useExtensionApi().note);
}

/**
 * Returns a function to mutate the `note` property of the checkout.
 */
function useApplyNoteChange() {
  return useExtensionApi().applyNoteChange;
}

export { useApplyNoteChange, useNote };
