import type { CartDiscountAllocation, CartDiscountCode, StandardApi, RenderExtensionPoint } from '@shopify/checkout-ui-extensions';
/**
 * Returns the current discount codes applied to the cart, and automatically re-renders
 * your component if discount codes are added or removed.
 */
export declare function useDiscountCodes<ID extends RenderExtensionPoint = RenderExtensionPoint>(): CartDiscountCode[];
/**
 * Returns the current discount allocations applied to the cart, and automatically re-renders
 * your component if discount allocations changed.
 */
export declare function useDiscountAllocations<ID extends RenderExtensionPoint = RenderExtensionPoint>(): CartDiscountAllocation[];
/**
 * Returns a function to add or remove discount codes.
 */
export declare function useApplyDiscountCodeChange<ID extends RenderExtensionPoint = RenderExtensionPoint>(): StandardApi<ID>['applyDiscountCodeChange'];
//# sourceMappingURL=discounts.d.ts.map