<!-- This is a partial markdown file that gets injected into the auto-generated https://shopify.dev/api/checkout-extensions/checkout/extension-points/api -->

<a name="appmetafieldfilters"></a>

### AppMetaFieldFilters

| Name       | Type                                                                    | Description                                                                                                                                                                                              |
| ---------- | ----------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| id?        | <code>string</code>                                                     | The numeric owner ID that is associated with the metafield.                                                                                                                                              |
| type?      | <code>"customer" &#124; "product" &#124; "shop" &#124; "variant"</code> | The type of the metafield owner.                                                                                                                                                                         |
| namespace? | <code>string</code>                                                     | Container for a set of metafields. You need to define a custom namespace for your metafields to distinguish them from the metafields used by other apps. This value must be between 2 and 20 characters. |
| key?       | <code>string</code>                                                     | The name of the metafield. This value must be between 3 and 30 characters.                                                                                                                               |

<a name="metafieldfilter"></a>

### MetaFieldFilter

| Name       | Type                | Description                                                                                                                                                                                                |
| ---------- | ------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| namespace? | <code>string</code> | A container for a set of metafields. You need to define a custom namespace for your metafields to distinguish them from the metafields used by other apps. This value must be between 2 and 20 characters. |
| key?       | <code>string</code> | The name of the metafield. This value must be between 3 and 30 characters.                                                                                                                                 |

---

### React Hooks

Shopify provides a collection of [React hooks](https://reactjs.org/docs/hooks-intro.html), which make it easy to update your UI when the checkout state changes.

```jsx
import React from 'react';
import {
  render,
  Text,
  useShippingAddress,
} from '@shopify/checkout-ui-extensions-react';

render('Checkout::Dynamic::Render', () => <App />);

function App() {
  // Access and subscribe to the shipping address
  // Your <App /> will automatically re-render when the address has changed
  const address = useShippingAddress();
  const firstName = address?.firstName ?? 'guest';

  // Render UI
  return <Text>Hi {firstName}!</Text>;
}
```

> Note:
> React hooks are only available if you're using React. If you're using vanilla JavaScript, then you'll need to manually subscribe to the subscribable value directly with a callback. For example, `shippingAddress.subscribe(newValue => updateYourUI())`.

| Name                                                            | Type                                                                                                                                                                                                                                                                                                                                                                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| --------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| useApplyAttributeChange                                         | <code>(change: <a href="#attributeupdatechange">AttributeUpdateChange</a>) => Promise<<wbr><a href="#attributechangeresultsuccess">AttributeChangeResultSuccess</a> &#124; <a href="#attributechangeresulterror">AttributeChangeResultError</a><wbr>></code>                                                                                                                     | Returns a function to mutate the `attributes` property of the checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| useApplyCartLinesChange                                         | <code>(change: <a href="#cartlineaddchange">CartLineAddChange</a> &#124; <a href="#cartlineremovechange">CartLineRemoveChange</a> &#124; <a href="#cartlineupdatechange">CartLineUpdateChange</a>) => Promise<<wbr><a href="#cartlinechangeresultsuccess">CartLineChangeResultSuccess</a> &#124; <a href="#cartlinechangeresulterror">CartLineChangeResultError</a><wbr>></code> | Returns a function to mutate the `lines` property of the checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| useApplyMetafieldsChange                                        | <code>(change: <a href="#metafieldremovechange">MetafieldRemoveChange</a> &#124; <a href="#metafieldupdatechange">MetafieldUpdateChange</a>) => Promise<<wbr><a href="#metafieldchangeresultsuccess">MetafieldChangeResultSuccess</a> &#124; <a href="#metafieldchangeresulterror">MetafieldChangeResultError</a><wbr>></code>                                                   | Returns a function to mutate the `metafields` property of the checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| useApplyNoteChange                                              | <code>(change: <a href="#noteremovechange">NoteRemoveChange</a> &#124; <a href="#noteupdatechange">NoteUpdateChange</a>) => Promise<<wbr><a href="#notechangeresultsuccess">NoteChangeResultSuccess</a> &#124; <a href="#notechangeresulterror">NoteChangeResultError</a><wbr>></code>                                                                                           | Returns a function to mutate the `note` property of the checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| useAppMetafields {% include /apps/checkout/privacy-icon.md %}   | <code>(filters?: <a href="#appmetafieldfilters">AppMetafieldFilters</a>) => <a href="#appmetafieldentry">AppMetaFieldEntry</a>[]</code>                                                                                                                                                                                                                                          | Returns the metafields configured with `shopify.ui.extension.toml`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| useAttributes                                                   | <code>() => <a href="#attribute">Attribute</a>[] &#124; undefined</code>                                                                                                                                                                                                                                                                                                         | Returns the proposed `attributes` applied to the checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| useBuyerJourney                                                 | <code>() => Promise<<wbr>() => void<wbr>></code>                                                                                                                                                                                                                                                                                                                                 | Returns the `buyerJourney` details on buyer progression in checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| useBuyerJourneyIntercept                                        | <code>(interceptor: <a href="#interceptor">Interceptor</a>) => void</code>                                                                                                                                                                                                                                                                                                       | A function for intercepting and preventing progression on checkout. You can block progress by returning an object with `{behavior: 'block', reason: InvalidResultReason.InvalidExtensionState}`. <br /><br />If you do, then you're expected to also update some part of your UI to reflect the reason why navigation was blocked. <br /><br />To block checkout progress, you must set the [block_progress](https://shopify.dev/api/checkout-extensions/checkout/configuration#block-progress) capability in your extension's configuration. |
| useSettings                                                     | <code>() => ExtensionSettings </code>                                                                                                                                                                                                                                                                                                                                            | Returns the settings defined by the merchant for the extension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| useCurrency                                                     | <code>() => string </code>                                                                                                                                                                                                                                                                                                                                                       | Returns the currency of the checkout, and automatically re-renders your component if the currency changes.                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| useCustomer {% include /apps/checkout/privacy-icon.md %}        | <code>() => <a href="#customer">Customer</a> &#124; undefined</code>                                                                                                                                                                                                                                                                                                             | Returns the account belonging to the customer.<br/><br/> The value is a <a href="#customer">Customer</a> if the customer has an account and is logged in, `undefined` otherwise. `ScopeNotGrantedError` is raised when access to [protected customer data](/apps/store/data-protection/protected-customer-data) hasn't been granted.                                                                                                                                                                                                          |
| useEmail {% include /apps/checkout/privacy-icon.md %}           | <code>() => string &#124; undefined </code>                                                                                                                                                                                                                                                                                                                                      | Returns the email of the buyer, and automatically re-renders your component if the email changes.<br/><br/>`ScopeNotGrantedError` is raised when access to [protected customer data](/apps/store/data-protection/protected-customer-data) hasn't been granted.                                                                                                                                                                                                                                                                                |
| useExtensionApi                                                 | <code>() => <a href="#standardapi">StandardApi<a></code>                                                                                                                                                                                                                                                                                                                         | Returns the full API object that was passed in to your extension when it was created.                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| useExtensionCapabilities                                        | <code>() => <a href="#capability">Capability</a>[]</code>                                                                                                                                                                                                                                                                                                                        | Returns a list of an extension's granted capabilities.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| useExtensionCapabilitiy                                         | <code>(capability: <a href="#capability">Capability</a>) => boolean</code>                                                                                                                                                                                                                                                                                                       | Returns whether or not a given capability of an extension is granted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| useExtensionData                                                | <code>() => <a href="#extension">Extension<a></code>                                                                                                                                                                                                                                                                                                                             | Returns the metadata about the extension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| useExtensionLanguage                                            | <code>() => string </code>                                                                                                                                                                                                                                                                                                                                                       | Returns the buyer's language, as supported by the extension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| useCartLines                                                    | <code>() => <a href="#cartline">CartLine</a>[] </code>                                                                                                                                                                                                                                                                                                                           | Returns the current cart lines for the checkout, and automatically re-renders your component if cart lines are added, removed, or updated.                                                                                                                                                                                                                                                                                                                                                                                                    |
| useLanguage                                                     | <code>() => string </code>                                                                                                                                                                                                                                                                                                                                                       | Returns the current language of the checkout, and automatically re-renders your component if the language changes.                                                                                                                                                                                                                                                                                                                                                                                                                            |
| useMetafield                                                    | <code>(filters: <a href="#metafieldfilter">MetaFieldFilter</a>) => <a href="#metafield">MetaField</a> &#124; undefined </code>                                                                                                                                                                                                                                                   | Returns a single filtered `Metafield` or `undefined`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| useMetafields                                                   | <code>(filters?: <a href="#metafieldfilter">MetaFieldFilter</a>) => <a href="#metafield">MetaField</a>[] </code>                                                                                                                                                                                                                                                                 | Returns the current array of `metafields` applied to the checkout. You can optionally filter the list.                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| useNote                                                         | <code>() => string &#124; undefined </code>                                                                                                                                                                                                                                                                                                                                      | Returns the proposed `note` applied to the checkout.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| usePhone {% include /apps/checkout/privacy-icon.md %}           | <code>() => string &#124; undefined </code>                                                                                                                                                                                                                                                                                                                                      | Returns the phone number of the buyer, and automatically re-renders your component if the phone number changes.<br/><br/>`ScopeNotGrantedError` is raised when access to [protected customer data](/apps/store/data-protection/protected-customer-data) hasn't been granted.                                                                                                                                                                                                                                                                  |
| useTotalAmount                                                  | <code>() => <a href="#money">Money</a> &#124; undefined</code>                                                                                                                                                                                                                                                                                                                   | Returns a `Money` value representing the minimum a buyer can expect to pay at the current step of checkout. This value excludes amounts yet to be negotiated. For example, the information step may not have delivery costs calculated.                                                                                                                                                                                                                                                                                                       |
| useShippingAddress {% include /apps/checkout/privacy-icon.md %} | <code>() => <a href="#mailingaddress">MailingAddress</a> &#124; undefined</code>                                                                                                                                                                                                                                                                                                 | Returns the proposed `shippingAddress` applied to the checkout. `ScopeNotGrantedError` is raised when access to [protected customer data](/apps/store/data-protection/protected-customer-data) hasn't been granted.                                                                                                                                                                                                                                                                                                                           |
| useShop                                                         | <code>() => <a href="#shop">Shop</a></code>                                                                                                                                                                                                                                                                                                                                      | Returns the `Shop` where the checkout is taking place.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| useStorage                                                      | <code>() => <a href="#storage">Storage</a></code>                                                                                                                                                                                                                                                                                                                                | Returns the key-value `Storage` interface for the extension point.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| useTarget                                                       | <code>() => <a href="#PresentmentCartLine">PresentmentCartLine</a></code>                                                                                                                                                                                                                                                                                                        | Returns the presentment cart line that the extension is attached to. Applicable only to the `Checkout::CartLineDetails::RenderAfter` extension point.                                                                                                                                                                                                                                                                                                                                                                                         |
| useTimezone                                                     | <code>() => string </code>                                                                                                                                                                                                                                                                                                                                                       | Returns the timezone of the checkout, and automatically re-renders your component if the timezone changes.                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| useTranslate                                                    | <code>() => <a href="#i18ntranslate">I18nTranslate</a></code>                                                                                                                                                                                                                                                                                                                    | Returns the `I18nTranslate` interface used to translate strings.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| useDiscountCodes                                                | <code>() => <a href="#cartdiscountcode">CartDiscountCode</a>[]</code>                                                                                                                                                                                                                                                                                                            | Returns the current discount codes applied to the cart, and automatically re-renders your component if discount codes are added or removed.                                                                                                                                                                                                                                                                                                                                                                                                   |
| useDiscountAllocations                                          | <code>() => <a href="#cartdiscountallocation">CartDiscountAllocation</a>[]</code>                                                                                                                                                                                                                                                                                                | Returns the current discount allocations applied to the cart, and automatically re-renders your component if discount allocations changed.                                                                                                                                                                                                                                                                                                                                                                                                    |
| useApplyDiscountCodeChange                                      | <code>(change: <a href="#discountcodechange">DiscountCodeChange</a>) => Promise<<wbr><a href="#discountcodechangeresult">DiscountCodeChangeResult</a><wbr>></code>                                                                                                                                                                                                               | Returns a function to add or remove discount codes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| useAppliedGiftCards                                             | <code>() => <a href="#appliedgiftcard">AppliedGiftCard</a>[]</code>                                                                                                                                                                                                                                                                                                              | Returns the current gift cards applied to the cart, and automatically re-renders your component if gift cards are added or removed.                                                                                                                                                                                                                                                                                                                                                                                                           |
| useApplyGiftCardChange                                          | <code>(change: <a href="#giftcardchange">GiftCardChange</a>) => Promise<<wbr><a href="#giftcardchangeresult">GiftCardChangeResult</a><wbr>></code>                                                                                                                                                                                                                               | Returns a function to add or remove gift cards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| useSessionToken                                                 | <code>() => <a href="#sessiontoken">SessionToken</a></code>                                                                                                                                                                                                                                                                                                                      | Returns a 'sessionToken' object, which contains a get() method that can be used to obtain a checkout extension session token.                                                                                                                                                                                                                                                                                                                                                                                                                 |
