'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@remote-ui/core');

/**
 * The form component should be used to wrap one or more form controls. This
 * component provides an "implicit submit" behavior, where customers can submit
 * the form from any input by pressing "Enter" on their keyboards. This
 * behavior is widely expected, and should be respected as often as possible.
 *
 * Unlike an HTML `form` element, this component does not support configuring
 * the descendant fields to be submitted via HTTP automatically. Instead, you
 * must provide an `onSubmit` callback that will perform the necessary HTTP
 * requests in JavaScript.
 */
const Form = core.createRemoteComponent('Form');

exports.Form = Form;
