'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@remote-ui/core');

/**
 * Popovers are similar to tooltips. They are small overlays that open on demand after a user interaction.
 * The difference is that the popover can contain more content, without cluttering the page.
 * They must be specified inside the `overlay` prop of an activator component (`Button`, `Link` or `Pressable`).
 *
 * The library takes care of applying the WAI-ARIA Popover Widget pattern automatically for the activator
 * and the popover content.
 */
const Popover = core.createRemoteComponent('Popover');

exports.Popover = Popover;
