# Pressable

Pressable is a generic interactive component. It shares the same styling properties as View but also adds
pressable behavior, meaning that you can execute some logic in response to user interaction.
Use this component for creating interactive elements without the default styling that comes with `Button` and `Link`.

## Props
optional = ?

| Name | Type | Description |
| --- | --- | --- |
| display? | <code>"block" &#124; "inline"</code> | Changes the display of the Pressable.<br /><br />`inline` follows the direction of words in a sentence based on the document’s writing mode.<br /><br />`block` follows the direction of paragraphs based on the document’s writing mode.<br /><br />Default value: <code>'block'</code> |
| accessibilityLabel? | <code>string</code> | A label that describes the purpose or contents of the element. When set, it will be announced to buyers using assistive technologies and will provide them with more context. |
| accessibilityRole? | <code>"button" &#124; "submit"</code> | The role of the button that will be rendered.<br /><br />`button`: renders a regular button.<br /><br />`submit`: renders a button that submits a form.<br /><br />Default value: <code>'button'</code> |
| disabled? | <code>boolean</code> | Disables the button, disallowing any interaction |
| id? | <code>string</code> | A unique identifier for the Pressable. |
| loading? | <code>boolean</code> | Disables the button while loading. Unlike `Button`, no indicator is rendered while loading. |
| onPress? | <code>() => void</code> | Callback that is run when the button or link is pressed. |
| onBlur? | <code>() => void</code> | Callback that is run when the button or link focus is removed. |
| onFocus? | <code>() => void</code> | Callback that is run when the button or link is focused. |
| onPointerDown? | <code>() => void</code> | Callback that is run when a pointing device button is pressed while the pointer is inside the button or link. |
| onPointerEnter? | <code>() => void</code> | Callback that is run when the pointing device is over (enters) the button or link. |
| onPointerLeave? | <code>() => void</code> | Callback that is run when the pointing device has left the button or link. |
| onPointerUp? | <code>() => void</code> | Callback that is run when a pointing device button is released while the pointer is inside the element button or link. |
| to? | <code>string</code> | Destination URL to link to. If this value is set, If this value is set, the component will render an `&lt;a&gt;` tag. |
| blockAlignment? | <code>"start" &#124; "center" &#124; "end" &#124; ConditionalStyle<<wbr>"start" &#124; "center" &#124; "end", AcceptedConditions<wbr>></code> | Position children along the cross axis |
| inlineAlignment? | <code><a href="#inlinealignment">InlineAlignment</a> &#124; ConditionalStyle<<wbr><a href="#inlinealignment">InlineAlignment</a>, AcceptedConditions<wbr>></code> | Position children along the main axis |
| border? | <code><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#borderstyle">BorderStyle</a><wbr>> &#124; ConditionalStyle<<wbr><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#borderstyle">BorderStyle</a><wbr>>, AcceptedConditions<wbr>></code> | Adjust the border style.<br /><br />To shorten the code, it is possible to specify all the border style properties in one property.<br /><br />For example:<br /><br />- `base` means blockStart, inlineEnd, blockEnd and inlineStart border styles are `base`<br /><br />- `['base', 'none']` means blockStart and blockEnd border styles are `base`, inlineStart and inlineEnd border styles are `none`<br /><br />- `['base', 'none', 'dotted', 'base']` means blockStart border style is `base`, inlineEnd border style is `none`, blockEnd border style is `dotted` and  blockStart border style is `base` |
| borderWidth? | <code><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#borderwidth">BorderWidth</a><wbr>> &#124; ConditionalStyle<<wbr><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#borderwidth">BorderWidth</a><wbr>>, AcceptedConditions<wbr>></code> | Adjust the border width.<br /><br />To shorten the code, it is possible to specify all the border width properties in one property.<br /><br />For example:<br /><br />- `base` means blockStart, inlineEnd, blockEnd and inlineStart border widths are `base`<br /><br />- `['base', 'medium']` means blockStart and blockEnd border widths are `base`, inlineStart and inlineEnd border widths are `medium`<br /><br />- `['base', 'medium', 'medium', 'base']` means blockStart border width is `base`, inlineEnd border width is `medium`, blockEnd border width is `medium` and  blockStart border width is `base` |
| borderRadius? | <code><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#cornerradius">CornerRadius</a><wbr>> &#124; ConditionalStyle<<wbr><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#cornerradius">CornerRadius</a><wbr>>, AcceptedConditions<wbr>></code> | @private<br /><br />Adjust the border radius.<br /><br />Provide a single value to apply the same border radius to all four corners, two values to apply different border radii to opposing corners, or four values to apply different border radii to each individual corner.<br /><br />For example:<br /><br />- `base` means all 4 border radii are `base`<br /><br />- `['base', 'none']` means the StartStart and EndEnd border radii are `base`, StartEnd and EndStart border radii are `none`.    When the context’s language direction is left to right, StartStart and EndEnd borders are the top left and bottom right borders    while StartEnd and EndStart borders are the top right and bottom left borders.<br /><br />- `['base', 'none', 'small', 'base']` means StartStart border radius is `base`, StartEnd border radius is `none`, EndEnd border radius is `small` and  EndStart border radius is `base` |
| cornerRadius? | <code><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#cornerradius">CornerRadius</a><wbr>> &#124; ConditionalStyle<<wbr><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#cornerradius">CornerRadius</a><wbr>>, AcceptedConditions<wbr>></code> | Adjust the corner radius.<br /><br />Provide a single value to apply the same corner radius to all four corners, two values to apply different corner radii to opposing corners, or four values to apply different corner radii to each individual corner.<br /><br />For example:<br /><br />- `base` means all 4 corner radii are `base`<br /><br />- `['base', 'none']` means the StartStart and EndEnd corner radii are `base`, StartEnd and EndStart corner radii are `none`.    When the context’s language direction is left to right, StartStart and EndEnd corners are the top left and bottom right corners    while StartEnd and EndStart corners are the top right and bottom left corners.<br /><br />- `['base', 'none', 'small', 'base']` means StartStart corner radius is `base`, StartEnd corner radius is `none`, EndEnd corner radius is `small` and  EndStart corner radius is `base`<br /><br />A `borderRadius` alias is available for this property. When both are specified, `cornerRadius` takes precedence. |
| maxBlockSize? | <code>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill" &#124; ConditionalStyle<<wbr>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill", AcceptedConditions<wbr>></code> | Adjust the maximum block size.<br /><br />`number`: size in pixels.<br /><br />`` `${number}%` ``: size in percentages.<br /><br />`fill`: takes all the available space. |
| maxInlineSize? | <code>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill" &#124; ConditionalStyle<<wbr>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill", AcceptedConditions<wbr>></code> | Adjust the maximum inline size.<br /><br />`number`: size in pixels.<br /><br />`` `${number}%` ``: size in percentages.<br /><br />`fill`: takes all the available space. |
| minInlineSize? | <code>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill" &#124; ConditionalStyle<<wbr>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill", AcceptedConditions<wbr>></code> | Adjust the minimum inline size.<br /><br />`number`: size in pixels.<br /><br />`` `${number}%` ``: size in percentages.<br /><br />`fill`: takes all the available space. |
| minBlockSize? | <code>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill" &#124; ConditionalStyle<<wbr>number &#124; &#96;&dollar;{number}%&#96; &#124; "fill", AcceptedConditions<wbr>></code> | Adjust the block size.<br /><br />`number`: size in pixels.<br /><br />`` `${number}%` ``: size in percentages.<br /><br />`fill`: takes all the available space. |
| padding? | <code><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#spacing">Spacing</a><wbr>> &#124; ConditionalStyle<<wbr><a href="#maybeshorthandproperty">MaybeShorthandProperty</a><<wbr><a href="#spacing">Spacing</a><wbr>>, AcceptedConditions<wbr>></code> | Adjust the padding.<br /><br />To shorten the code, it is possible to specify all the padding properties in one property.<br /><br />Examples:<br /><br />- `base` means blockStart, inlineEnd, blockEnd and inlineStart paddings are `base`<br /><br />- [`base`, `none`] means blockStart and blockEnd paddings are `base`, inlineStart and inlineEnd paddings are `none`<br /><br />- [`base`, `none`, `loose`, `tight`] means blockStart padding is `base`, inlineEnd padding is `none`, blockEnd padding is `loose` and  blockStart padding is `tight` |
| overlay? | <code>RemoteFragment</code> | An overlay component to render when the user interacts with the component. |
| opacity? | <code>10 &#124; 20 &#124; 30 &#124; 40 &#124; 50 &#124; 60 &#124; 70 &#124; 80 &#124; 90</code> | Sets the opacity of the View. The opacity will be applied to the background as well as all the children of the View. Use carefully as this could decrease the contrast ratio between the background and foreground elements, resulting in unreadable and inaccessible text. |
<a name="Spacing"></a>

### Spacing

<code>"none" &#124; "extraTight" &#124; "tight" &#124; "base" &#124; "loose" &#124; "extraLoose"</code>
<a name="CornerRadius"></a>

### CornerRadius

<code>"base" &#124; "small" &#124; "large" &#124; "fullyRounded" &#124; "none" &#124; <a href="#cornerradiusdeprecated">CornerRadiusDeprecated</a></code>
<a name="CornerRadiusDeprecated"></a>

### CornerRadiusDeprecated

<code>"tight" &#124; "loose"</code>
<a name="BorderWidth"></a>

### BorderWidth

<code>"base" &#124; "medium"</code>
<a name="MaybeShorthandProperty"></a>

### MaybeShorthandProperty

<code>T &#124; <a href="#shorthandproperty">ShorthandProperty</a><<wbr>T<wbr>></code>
<a name="ShorthandProperty"></a>

### ShorthandProperty

<code>[T, T] &#124; [T, T, T, T]</code>
<a name="BorderStyle"></a>

### BorderStyle

<code>"base" &#124; "dotted" &#124; "none"</code>
<a name="InlineAlignment"></a>

### InlineAlignment

<code>"start" &#124; "center" &#124; "end"</code>