/**
 * Returns whether an environment variable value represents a truthy value.
 */
export function isTruthy(variable) {
    if (!variable) {
        return false;
    }
    return ['1', 'true', 'TRUE', 'yes', 'YES'].includes(variable);
}
/**
 * Returns whether an environment variable has been set and is non-empty
 */
export function isSet(variable) {
    if (variable === undefined || variable.trim() === '') {
        return false;
    }
    return true;
}
//# sourceMappingURL=utilities.js.map