/* eslint-disable id-length */
import { Text } from 'ink';
import React, { useEffect, useRef, useState } from 'react';
import gradient from 'gradient-string';
function rainbow(text, frame) {
    const hue = 5 * frame;
    const leftColor = { h: hue % 360, s: 0.8, v: 1 };
    const rightColor = { h: (hue + 1) % 360, s: 0.8, v: 1 };
    return gradient(leftColor, rightColor)(text, { interpolation: 'hsv', hsvSpin: 'long' });
}
/**
 * `TextAnimation` applies a rainbow animation to text.
 */
const TextAnimation = ({ text }) => {
    const frame = useRef(0);
    const [renderedFrame, setRenderedFrame] = useState(text);
    const timeout = useRef();
    const renderAnimation = () => {
        const newFrame = frame.current + 1;
        frame.current = newFrame;
        setRenderedFrame(rainbow(text, frame.current));
        timeout.current = setTimeout(() => {
            renderAnimation();
        }, 35);
    };
    useEffect(() => {
        renderAnimation();
        return () => {
            clearTimeout(timeout.current);
        };
    }, []);
    return React.createElement(Text, null, renderedFrame);
};
export { TextAnimation };
//# sourceMappingURL=TextAnimation.js.map