import useLayout from '../hooks/use-layout.js';
import { Box, Text } from 'ink';
import React, { useCallback } from 'react';
import chalk from 'chalk';
const TopBottomPadding = ({ padding, color, width, inverse }) => {
    return (React.createElement(React.Fragment, null, [...Array(padding).keys()].map((index) => (React.createElement(Text, { key: index, backgroundColor: color, inverse: inverse }, ' '.repeat(width))))));
};
const TextWithBackground = ({ backgroundColor, inverse, padding, paddingX, paddingY, text, }) => {
    const pY = (padding ? padding : paddingY) ?? 0;
    const pX = (padding ? padding : paddingX) ?? 0;
    const color = backgroundColor;
    const { fullWidth: width } = useLayout();
    const textWidth = width - pX * 2;
    let colorName;
    if (color) {
        colorName = `bg${color[0].toUpperCase() + color.slice(1)}`;
    }
    else if (inverse) {
        colorName = 'inverse';
    }
    else {
        throw new Error('Either backgroundColor or inverse must be set');
    }
    const textTransform = useCallback((textToTransform) => {
        // split text into lines of width length
        const lines = textToTransform.match(new RegExp(`.{1,${textWidth}}`, 'g')) || [];
        // pad each line to width length
        const paddedLines = lines.map((line) => `${' '.repeat(pX)}${line}${' '.repeat(pX)}`.padEnd(width, ' '));
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return chalk[colorName](paddedLines.join('\n'));
    }, [colorName, pX, textWidth]);
    return (React.createElement(Box, { flexDirection: "column" },
        pY ? React.createElement(TopBottomPadding, { padding: pY, color: color, width: width, inverse: inverse }) : null,
        React.createElement(Box, { flexGrow: 1 },
            React.createElement(Text, null, textTransform(text))),
        pY ? React.createElement(TopBottomPadding, { padding: pY, color: color, width: width, inverse: inverse }) : null));
};
export { TextWithBackground };
//# sourceMappingURL=TextWithBackground.js.map