import { partnersFqdn } from '../context/fqdn.js';
import { graphqlRequest } from '../../../private/node/api/graphql.js';
import { gql } from 'graphql-request';
/**
 * Executes a GraphQL query against the Partners API.
 *
 * @param query - GraphQL query to execute.
 * @param token - Partners token.
 * @param variables - GraphQL variables to pass to the query.
 * @returns The response of the query of generic type <T>.
 */
export async function partnersRequest(query, token, variables) {
    const api = 'Partners';
    const fqdn = await partnersFqdn();
    const url = `https://${fqdn}/api/cli/graphql`;
    return graphqlRequest(query, api, url, token, variables);
}
/**
 * Function queries are proxied through the script service proxy.
 * To execute a query, we encapsulate it inside another query (including the variables)
 * This is done automatically, you just need to provide the query and the variables.
 *
 * @param apiKey - APIKey of the app where the query will be executed.
 * @param query - GraphQL query to execute.
 * @param token - Partners token.
 * @param variables - GraphQL variables to pass to the query.
 * @returns The response of the query.
 */
export async function functionProxyRequest(apiKey, query, token, variables) {
    const proxyVariables = {
        api_key: apiKey,
        query,
        variables: JSON.stringify(variables) || '{}',
    };
    const proxyQuery = ScriptServiceProxyQuery;
    const res = await partnersRequest(proxyQuery, token, proxyVariables);
    const json = JSON.parse(res.scriptServiceProxy);
    return json;
}
const ScriptServiceProxyQuery = gql `
  query ProxyRequest($api_key: String, $query: String!, $variables: String) {
    scriptServiceProxy(apiKey: $api_key, query: $query, variables: $variables)
  }
`;
//# sourceMappingURL=partners.js.map