# `@shopify/app-bridge`

**[Join our team and work on libraries like this one.](https://www.shopify.ca/careers)**

[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](LICENSE.md)
[![npm version](https://badge.fury.io/js/%40shopify%2Fapp-bridge.svg)](https://badge.fury.io/js/%40shopify%2Fapp-bridge.svg)
[![npm bundle size (minified + gzip)](https://img.shields.io/bundlephobia/minzip/@shopify/app-bridge.svg)](https://img.shields.io/bundlephobia/minzip/@shopify/app-bridge.svg)

You can use [Shopify App Bridge](https://shopify.dev/tools/app-bridge) to embed apps and channels directly into the Shopify admin, Shopify Mobile, and Shopify POS. Shopify App Bridge helps to reduce your development time by accessing native Shopify features across different platforms, and makes sure that the user experience is consistent wherever merchants are using your app.

Shopify App Bridge is a replacement for the now deprecated [Embedded App SDK](https://shopify.dev/tools/embedded-app-sdk).

## Installation

You can install Shopify App Bridge by using [Yarn](https://yarnpkg.com):

```sh
yarn add @shopify/app-bridge
```

## Usage

### Set up your app

In the following example, you need to store `host` during the authentication process and then retrieve it for the code to work properly. To learn more about this process, see [Getting and storing the shop origin](https://shopify.dev/tutorials/get-and-store-the-shop-origin).

Import the library from the `@shopify/app-bridge` package and provide a configuration:

```typescript
import createApp from '@shopify/app-bridge';

const app = createApp({
  apiKey: 'API key from Shopify Partner Dashboard',
  host: 'host from URL search parameter',
});
```

### Actions

Shopify App Bridge introduces the concept of actions. An action provides a way for applications and hosts to trigger events with a statically-typed payload.

To learn more about the supported actions, see the [actions documentation](https://shopify.dev/tools/app-bridge/actions).

### App State

Once the app is set up, you can access additional details and the state of the app at
any time by making async call `app.getState()`:

```typescript
app.getState().then((state: any) => {
  console.info('App State: %o', state);
});
```

You can also use a shorthand to retrieve nested properties by passing in a `query` when calling `getState(query)`, for example:

```typescript
app.getState('pos.user').then((user: any) => {
  console.log('POS User: %o', user);
});
```

### Hooks

Shopify App Bridge can be extended with hooks, which run when actions are dispatched and updated.
Hooks are middleware that can modify or cancel actions.

### Development & Debugging

Shopify App Bridge is shipped with a development build, which provides detailed debugging information during development.

If you're consuming App Bridge from a CDN or using the UMD build, simply include the development version:
`umd/index.development.js` instead of `umd/index.js`

When consumed as JS Modules, development/production build is dynamically selected based on the `NODE_ENV` variable. Development build is used when `NODE_ENV=development`.

Please note that the development build is not intended for production use, as the file size is significantly larger.
