import { Group, MetaAction } from '../types';
export declare enum Action {
    REQUEST = "APP::AUTH_CODE::REQUEST",
    RESPOND = "APP::AUTH_CODE::RESPOND"
}
export interface ExchangeRequiredPayload {
    status: 'needsExchange';
    code: string;
    hmac: string;
    timestamp: string;
    shop: string;
    readonly id: string;
}
export interface FailedResponsePayload {
    status: 'failure';
    readonly id: string;
}
export declare type ResponsePayload = ExchangeRequiredPayload | FailedResponsePayload;
export interface RequestPayload {
    readonly id: string;
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.AuthCode;
}
export interface RequestAuthCodeAction extends ActionBase {
    readonly type: typeof Action.REQUEST;
    payload: RequestPayload;
}
export interface RespondWithAuthCodeAction extends ActionBase {
    readonly type: typeof Action.RESPOND;
    payload?: ResponsePayload;
}
export declare function request(id: string): RequestAuthCodeAction;
export declare function respond(payload?: ResponsePayload): RespondWithAuthCodeAction;
