import { ClientApplication } from '../../client';
import { ActionSet } from '../ActionSet';
import { Group, ActionSetProps, MetaAction } from '../types';
/**
 * ContextualSaveBar action enum
 */
export declare enum Action {
    DISCARD = "APP::CONTEXTUAL_SAVE_BAR::DISCARD",
    SAVE = "APP::CONTEXTUAL_SAVE_BAR::SAVE",
    SHOW = "APP::CONTEXTUAL_SAVE_BAR::SHOW",
    HIDE = "APP::CONTEXTUAL_SAVE_BAR::HIDE",
    UPDATE = "APP::CONTEXTUAL_SAVE_BAR::UPDATE"
}
export interface ContextAction {
    /**
     * @deprecated as of 1.6.0
     */
    label?: string;
    disabled?: boolean;
    loading?: boolean;
}
export interface DiscardAction extends ContextAction {
    discardConfirmationModal?: boolean;
}
/**
 * ContextualSaveBar action options interface
 */
export interface Options {
    fullWidth?: boolean;
    discardAction?: DiscardAction;
    saveAction?: ContextAction;
    leaveConfirmationDisable?: boolean;
    /**
     * @deprecated as of 1.6.0
     */
    message?: string;
}
/**
 * ContextualSaveBar action payload interface
 */
export interface Payload extends Options {
    readonly id: string;
}
/**
 * ContextualSaveBar action interface
 * @internal
 */
export interface ContextualSaveBarAction extends MetaAction {
    readonly group: typeof Group.ContextualSaveBar;
    readonly type: Action;
    payload: Payload;
}
export declare type ShowOptions = Pick<Options, 'fullWidth' | 'leaveConfirmationDisable'>;
export interface SaveActionOptions extends ContextAction {
    onAction?: () => void;
}
export interface DiscardActionOptions extends DiscardAction {
    onAction?: () => void;
}
export interface ContextualSaveBarApi {
    show: ({ fullWidth, leaveConfirmationDisable }?: ShowOptions) => void;
    hide: () => void;
    saveAction: {
        setOptions: (options: Partial<SaveActionOptions>) => void;
    };
    discardAction: {
        setOptions: (options: Partial<DiscardActionOptions>) => void;
    };
}
export declare function show(payload: Payload): any;
export declare function hide(payload: Payload): any;
export declare function save(payload: Payload): any;
export declare function discard(payload: Payload): any;
export declare function update(payload: Payload): any;
/**
 * ContextualSaveBar action set
 */
export declare class ContextualSaveBar extends ActionSet implements ActionSetProps<Options, Payload> {
    options: Options;
    /**
     * Returns a new instance of a ContextualSaveBar action set
     * @param app the client application
     */
    constructor(app: ClientApplication, options?: Options);
    /**
     * Returns the action set payload
     */
    get payload(): {
        fullWidth?: boolean | undefined;
        discardAction?: DiscardAction | undefined;
        saveAction?: ContextAction | undefined;
        leaveConfirmationDisable?: boolean | undefined;
        /**
         * @deprecated as of 1.6.0
         */
        message?: string | undefined;
        id: string;
    };
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    dispatch(action: Action): this;
}
/**
 * Returns a new instance of a ContextualSaveBar action set
 * @param app the client application
 *
 */
export declare function create(app: ClientApplication, options?: Options): ContextualSaveBar;
